/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import android.util.Log;
import net.doo.snap.b.k;
import net.doo.snap.c.c;
import net.doo.snap.camera.barcode.ScanbotBarcodeDetector;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.log.StubLogger;

public class ScanbotSDKInitializer {
    private static boolean a = false;
    private boolean b = false;
    private Logger c;

    public ScanbotSDKInitializer withLogging(boolean useLog) {
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.b = useLog;
        if (!useLog) {
            this.c = new StubLogger();
        }
        return this;
    }

    public ScanbotSDKInitializer license(Application application, String license) {
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_LICENSE_KEY", license).apply();
        return this;
    }

    public ScanbotSDKInitializer ocrBlobsPath(Application application, String ocrBlobsPath) {
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", ocrBlobsPath).apply();
        return this;
    }

    public ScanbotSDKInitializer languageClassifierBlobPath(Application application, String languageClassifierBlobPath) {
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_LANGUAGE_CLASSIFIER_BLOB_PATH", languageClassifierBlobPath).apply();
        return this;
    }

    public void initialize(Application application) {
        LoggerProvider.setLogger(this.c == null ? new DebugLog((Context)application) : this.c);
        boolean bl = net.doo.snap.c.c.b((Context)application).isLicenseActive();
        String string = "ScanbotSDK license is " + (bl ? "valid." : "not valid or expired.");
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", string);
        a = true;
    }

    public static boolean isInitialized() {
        return a;
    }

    public ScanbotSDKInitializer documentDraftExtractor(DocumentDraftExtractor extractor) {
        k.a = extractor;
        return this;
    }

    public ScanbotSDKInitializer unreferencedSourcesProvider(UnreferencedSourcesProvider provider) {
        k.b = provider;
        return this;
    }

    public ScanbotSDKInitializer logger(Logger logger) {
        this.c = logger;
        return this;
    }

    public ScanbotSDKInitializer useBarcodeDetector(ScanbotBarcodeDetector.BarcodeDetectorType barcodeDetector) {
        k.c = barcodeDetector;
        return this;
    }
}

