/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    public static final String a = "thumbnail";
    public static final String b = "tmp_";
    private static final String c = "%s(%d)%s";
    private static final String d = " (1).";
    private final Context e;
    private final SharedPreferences f;
    private final Logger g = LoggerProvider.getLogger();

    @Inject
    public DocumentStoreStrategy(Context context, SharedPreferences preferences) {
        this.e = context;
        this.f = preferences;
    }

    public boolean ensureDocumentDir(File docDir) {
        File[] fileArray;
        return docDir != null && docDir.exists() && (fileArray = docDir.listFiles()) != null && fileArray.length > 0;
    }

    public File getDocumentsDir() throws IOException {
        return net.doo.snap.util.FileUtils.getExternalFilesDirOrShowError(this.e, "snapping_documents");
    }

    public File getDocumentsExternalDir() throws IOException {
        File file;
        String string2 = this.f.getString("EXTERNAL_DIR", "Scanbot");
        if (!TextUtils.isEmpty((CharSequence)string2) && ((file = new File(string2)).exists() || file.mkdirs())) {
            return file;
        }
        return net.doo.snap.util.FileUtils.getExternalStorageDirOrShowError(this.e, "Scanbot");
    }

    public File getDocumentsDirForSharing() throws IOException {
        return net.doo.snap.util.FileUtils.getExternalCacheDirOrShowError(this.e, "documents_for_sharing");
    }

    public File getDocumentDirForSharing(String docId) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDirForSharing(), (String[])new String[]{docId});
    }

    public File getDocumentDir(String docId) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{docId});
    }

    public void ensureDocumentDirectory(String docId) throws IOException {
        FileUtils.forceMkdir((File)this.getDocumentDir(docId));
    }

    public File getDocumentFile(String docId, String name) throws IOException {
        return FileUtils.getFile((File)this.getDocumentDir(docId), (String[])new String[]{name});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.getDocumentsDir().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File[] fileArray2 = fileArray[i2].listFiles(new FilenameFilter(){

                @Override
                public final boolean accept(File dir, String filename) {
                    return filename.endsWith(".jpg") || filename.endsWith(".pdf");
                }
            });
            arrayList.addAll(Arrays.asList(fileArray2));
        }
        return arrayList;
    }

    public File getThumbnailFile(String docId) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{docId, a});
    }

    public File getTemporaryDocumentFile(String docId, String name) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{docId, b + name});
    }

    public File getDocumentFileForSharing(String docId, String name) throws IOException {
        File file = FileUtils.getFile((File)this.getDocumentsDirForSharing(), (String[])new String[]{docId, name});
        FileUtils.copyFile((File)this.getDocumentFile(docId, name), (File)file);
        return file;
    }

    public void eraseDocument(String docId, String docName) {
        try {
            FileUtils.deleteQuietly((File)this.getDocumentFile(docId, docName));
            FileUtils.deleteQuietly((File)this.getDocumentDir(docId));
            FileUtils.deleteQuietly((File)this.getDocumentDirForSharing(docId));
            return;
        }
        catch (IOException iOException) {
            this.g.logException(iOException);
            return;
        }
    }

    public boolean renameDocument(String docId, String oldName, String newName) throws IOException {
        newName = this.getUniqueName(newName);
        File file = this.getDocumentFile(docId, newName);
        return this.getDocumentFile(docId, oldName).renameTo(file);
    }

    public String getUniqueName(String newName) {
        while (true) {
            String string2;
            String string3 = TextUtils.isEmpty((CharSequence)(string2 = FilenameUtils.getExtension((String)newName))) ? "" : "." + string2;
            String string4 = FilenameUtils.getBaseName((String)newName);
            int n2 = string4.lastIndexOf("(");
            int n3 = string4.lastIndexOf(")");
            Integer n4 = 0;
            String string5 = FilenameUtils.getBaseName((String)newName);
            if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                try {
                    n4 = Integer.valueOf(string4.substring(n2 + 1, n3));
                    string5 = string4.substring(0, n2 - 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            try {
                boolean bl = false;
                Iterator<File> iterator = this.getDocumentsFiles().iterator();
                while (iterator.hasNext()) {
                    if (!FilenameUtils.getBaseName((String)iterator.next().getName()).equals(string4)) continue;
                    newName = string5 + " (" + (n4 + 1) + ")" + string3;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            catch (IOException iOException) {
                this.g.logException(iOException);
                break;
            }
        }
        return newName;
    }

    public String getPageImagePath(int pagePosition, Document document) throws IOException {
        return String.format(c, FilenameUtils.removeExtension((String)this.getDocumentFile(document.getId(), document.getName()).getPath()), pagePosition, ".jpg");
    }

    public void migrateDocuments(String newPath, List<Document> documents) {
        boolean bl = !TextUtils.isEmpty((CharSequence)newPath);
        for (Document document : documents) {
            try {
                try {
                    String string2 = document.getName();
                    String string3 = document.getId();
                    File file = bl ? new File(newPath) : this.getDocumentDir(string3);
                    String string4 = string2;
                    if (FileUtils.getFile((File)file, (String[])new String[]{string2}).exists()) {
                        String string5 = FilenameUtils.getExtension((String)string2);
                        String string6 = FilenameUtils.getBaseName((String)string2);
                        string4 = string6 + d + string5;
                        this.renameDocument(string3, string2, string4);
                    }
                    FileUtils.moveFileToDirectory((File)this.getDocumentFile(string3, string4), (File)file, (boolean)true);
                }
                catch (IOException iOException) {
                    this.g.logException(iOException);
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

