/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import net.doo.snap.util.CursorUtil;

public class FileChooserUtils {
    private static final String CONTENT_SCHEME = "content";
    private static final String FILE_SCHEME = "file";
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileChooserUtils.isExternalStorageDocument(uri)) {
                String[] stringArray = DocumentsContract.getDocumentId((Uri)uri).split(":");
                String string = stringArray[0];
                if ("primary".equalsIgnoreCase(string)) {
                    return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                }
            } else {
                if (FileChooserUtils.isDownloadsDocument(uri)) {
                    String string = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)Long.valueOf(string));
                    return FileChooserUtils.getDataColumn(context, uri2, null, null);
                }
                if (FileChooserUtils.isMediaDocument(uri)) {
                    String[] stringArray = DocumentsContract.getDocumentId((Uri)uri).split(":");
                    String string = stringArray[0];
                    Uri uri3 = null;
                    if ("image".equals(string)) {
                        uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    }
                    String[] stringArray2 = new String[]{stringArray[1]};
                    return FileChooserUtils.getDataColumn(context, uri3, "_id=?", stringArray2);
                }
            }
        } else {
            if (CONTENT_SCHEME.equalsIgnoreCase(uri.getScheme())) {
                return FileChooserUtils.getDataColumn(context, uri, null, null);
            }
            if (FILE_SCHEME.equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String[] stringArray = new String[]{"_data"};
        if (context == null) {
            return uri.getPath();
        }
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return uri.getPath();
        }
        Cursor cursor = contentResolver.query(uri, stringArray, selection, selectionArgs, null);
        if (cursor != null) {
            int n2 = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String string = cursor.getString(n2);
            CursorUtil.closeQuietly(cursor);
            return string;
        }
        return uri.getPath();
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return EXTERNALSTORAGE_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return DOWNLOADS_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return MEDIA_AUTHORITY.equals(uri.getAuthority());
    }
}

