/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BitmapUtils {
    public static Rect getBitmapBounds(String path) {
        Rect rect = new Rect();
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        rect.set(0, 0, options.outWidth, options.outHeight);
        return rect;
    }

    public static boolean isBitmapValid(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    public static Rect getContentBounds(Bitmap bitmap) throws NullPointerException {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap is null");
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < bitmap.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bitmap.getWidth(); ++i3) {
                if (bitmap.getPixel(i3, i2) == 0) continue;
                if (i3 < n2) {
                    n2 = i3;
                }
                if (i2 < n3) {
                    n3 = i2;
                }
                if (i3 > n4) {
                    n4 = i3;
                }
                if (i2 <= n5) continue;
                n5 = i2;
            }
        }
        return new Rect(n2, n3, n4, n5);
    }

    public static void compress(Bitmap bitmap, Bitmap.CompressFormat format, int quality, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(format, quality, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    public static Bitmap createPreview(Resources res, int imageRes, int targetWidth, int targetHeight) {
        if (imageRes <= 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)imageRes, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)imageRes, (BitmapFactory.Options)options);
    }

    public static Bitmap createPreview(byte[] image, int targetWidth, int targetHeight) {
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        boolean bl;
        int n2 = options.outWidth;
        int n3 = options.outHeight;
        boolean bl2 = n2 > n3;
        boolean bl3 = bl = reqWidth > reqHeight;
        if (bl2 != bl) {
            n3 = options.outWidth;
            n2 = options.outHeight;
        }
        int n4 = 1;
        if (n3 > reqHeight || n2 > reqWidth) {
            int n5 = n3 / 2;
            int n6 = n2 / 2;
            while (n5 / n4 > reqHeight && n6 / n4 > reqWidth) {
                n4 *= 2;
            }
        }
        return n4;
    }

    public static Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmapDrawable = new Canvas(bitmap);
        drawable.setBounds(0, 0, bitmapDrawable.getWidth(), bitmapDrawable.getHeight());
        drawable.draw((Canvas)bitmapDrawable);
        return bitmap;
    }
}

