/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.payformscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.payformscanner.PayFormScanner;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.payformscanner.PayFormScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class PayFormScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private PayFormScanner payFormScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static PayFormScannerFrameHandler attach(ScanbotCameraView cameraView, PayFormScanner payFormScanner) {
        PayFormScannerFrameHandler payFormScannerFrameHandler = new PayFormScannerFrameHandler(cameraView.getContext(), payFormScanner);
        cameraView.getPreviewBuffer().addFrameHandler(payFormScannerFrameHandler);
        return payFormScannerFrameHandler;
    }

    public PayFormScannerFrameHandler(Context context, PayFormScanner payFormScanner) {
        this.payFormScanner = payFormScanner;
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] frame, int width, int height, int frameOrientation, Rect finderRect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        PayFormScanner.DetectionResult detectionResult = this.payFormScanner.preVerifyForm(frame, width, height);
        return this.notifyHandlers(detectionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(PayFormScanner.DetectionResult detectionResult) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(detectionResult);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(PayFormScanner.DetectionResult var1);
    }
}

