/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.app.DownloadManager;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.util.CursorUtil;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class BlobManager {
    private final BlobStoreStrategy blobStoreStrategy;
    private final DownloadManager downloadManager;
    private final SharedPreferences sharedPreferences;
    private final AssetManager assetManager;
    private final BlobFactory blobFactory;
    private final Logger logger = LoggerProvider.getLogger();

    @Inject
    public BlobManager(BlobStoreStrategy blobStoreStrategy, DownloadManager downloadManager, SharedPreferences sharedPreferences, AssetManager assetManager, BlobFactory blobFactory) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.downloadManager = downloadManager;
        this.sharedPreferences = sharedPreferences;
        this.assetManager = assetManager;
        this.blobFactory = blobFactory;
    }

    public boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) {
        for (Blob blob : blobs) {
            if (this.isBlobAvailable(blob)) continue;
            return false;
        }
        return true;
    }

    public boolean isBlobAvailable(@NotNull Blob blob) {
        return new File(blob.getLocalPath()).exists();
    }

    @NotNull
    public Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        EnumSet<Language> enumSet = EnumSet.noneOf(Language.class);
        File[] fileArray = this.blobStoreStrategy.getOCRDataDirectory().listFiles();
        if (fileArray == null) {
            return enumSet;
        }
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Language language;
            File file = fileArray2[i2];
            if (file.isDirectory() || (language = Language.languageByIso(FilenameUtils.removeExtension((String)file.getName()))) == null || !this.allBlobsAvailable(this.blobFactory.ocrLanguageBlobs(language))) continue;
            enumSet.add(language);
        }
        return enumSet;
    }

    @NotNull
    public File getOCRBlobsDirectory() throws IOException {
        File file = this.blobStoreStrategy.getOCRDataDirectory();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't get OCR blobs directory");
        }
        return file;
    }

    @NotNull
    public File getBanksDataFile() throws IOException {
        File file = this.blobStoreStrategy.getBanksDataFile();
        if (!file.exists()) {
            throw new IOException("Can't get banks data file");
        }
        return file;
    }

    @NotNull
    public File getMRZTraineddataFile() throws IOException {
        File file = this.blobStoreStrategy.getMRZTraindataFile();
        if (!file.exists()) {
            throw new IOException("Can't get MRZ traineddata file");
        }
        return file;
    }

    public long fetch(@NotNull Blob blob, boolean allowMeteredNetwork) throws IOException {
        if (this.isBlobAvailable(blob)) {
            return -1L;
        }
        this.ensureDirectoryCreated(blob);
        Uri uri = Uri.parse((String)blob.getRemotePath());
        if (TextUtils.isEmpty((CharSequence)uri.getScheme())) {
            return this.copyFromAssets(blob, uri);
        }
        return this.download(blob, uri, allowMeteredNetwork);
    }

    private long copyFromAssets(Blob blob, Uri blobUri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.assetManager.open(blobUri.getPath()), (File)new File(blob.getLocalPath()));
        return -1L;
    }

    private long download(Blob blob, Uri blobUri, boolean allowMeteredNetwork) throws IOException {
        int n2 = 2;
        if (allowMeteredNetwork) {
            n2 = 3;
        }
        DownloadManager.Request request = new DownloadManager.Request(blobUri).setAllowedNetworkTypes(n2).setDestinationUri(Uri.fromFile((File)new File(blob.getLocalPath())));
        long l2 = this.downloadManager.enqueue(request);
        this.saveDownloadId(l2);
        return l2;
    }

    private void ensureDirectoryCreated(Blob blob) throws IOException {
        File file = new File(blob.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create destination directory");
        }
    }

    private void saveDownloadId(long downloadId) {
        HashSet<String> hashSet = new HashSet<String>(this.sharedPreferences.getStringSet("STARTED_BLOB_DOWNLOADS", Collections.EMPTY_SET));
        hashSet.add(String.valueOf(downloadId));
        this.sharedPreferences.edit().putStringSet("STARTED_BLOB_DOWNLOADS", hashSet).apply();
    }

    public boolean hasActiveDownloads() {
        String string22;
        HashSet hashSet = new HashSet(this.sharedPreferences.getStringSet("STARTED_BLOB_DOWNLOADS", Collections.EMPTY_SET));
        if (hashSet.isEmpty()) {
            return false;
        }
        long[] lArray = new long[hashSet.size()];
        int n2 = 0;
        for (String string22 : hashSet) {
            lArray[n2] = Long.parseLong(string22);
            ++n2;
        }
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(lArray);
        query.setFilterByStatus(7);
        string22 = this.downloadManager.query(query);
        try {
            boolean bl = CursorUtil.hasElements((Cursor)string22);
            return bl;
        }
        finally {
            CursorUtil.closeQuietly((Cursor)string22);
        }
    }

    public HashSet<Blob> blobsToDownload(Collection<Language> languages) {
        HashSet<Blob> hashSet = new HashSet<Blob>();
        try {
            hashSet.addAll(this.blobFactory.languageDetectorBlobs());
            for (Language language : languages) {
                hashSet.addAll(this.blobFactory.ocrLanguageBlobs(language));
                hashSet.addAll(this.blobFactory.documentClassifierBlobs(language));
            }
        }
        catch (IOException iOException) {
            this.logger.logException(iOException);
        }
        return hashSet;
    }
}

