/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.util.SparseArray;

public enum RotationType {
    ROTATION_0(0),
    ROTATION_90(90),
    ROTATION_180(180),
    ROTATION_270(270),
    ROTATION_360(360);

    private final int degrees;
    private static final SparseArray<RotationType> degrees2Type;

    private RotationType(int degrees) {
        this.degrees = degrees;
    }

    public static RotationType rotateClockwise(RotationType type) {
        RotationType rotationType = ROTATION_0;
        switch (type) {
            case ROTATION_360: 
            case ROTATION_0: {
                rotationType = ROTATION_90;
                break;
            }
            case ROTATION_90: {
                rotationType = ROTATION_180;
                break;
            }
            case ROTATION_180: {
                rotationType = ROTATION_270;
                break;
            }
            case ROTATION_270: {
                rotationType = ROTATION_360;
            }
        }
        return rotationType;
    }

    public final int getDegrees() {
        return this.degrees;
    }

    public static RotationType getByDegrees(int degrees) {
        RotationType rotationType = (RotationType)((Object)degrees2Type.get(degrees));
        if (rotationType == null) {
            throw new IllegalStateException("no rottation type for: " + degrees);
        }
        return rotationType;
    }

    static {
        degrees2Type = new SparseArray();
        for (RotationType rotationType : RotationType.values()) {
            degrees2Type.put(rotationType.degrees, (Object)rotationType);
        }
    }
}

