/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.entity.OptimizationType;
import net.doo.snap.entity.Page;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class PageStoreStrategy {
    public static final String a = "filtered";
    private final Application b;
    private final Logger c = LoggerProvider.getLogger();

    @Inject
    public PageStoreStrategy(Application context) {
        this.b = context;
    }

    @NotNull
    public File getPagesDir() throws IOException {
        return net.doo.snap.util.FileUtils.getExternalFilesDirOrShowError((Context)this.b, "snapping_pages");
    }

    @NotNull
    public File getPageDir(String pageId) throws IOException {
        return FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId});
    }

    @NotNull
    public File getImageFile(@NotNull String pageId, @NotNull Page.ImageType imageType) throws IOException {
        return FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, imageType.getFileName()});
    }

    public File getFilteredPreviewFile(@NotNull String pageId, @NotNull OptimizationType optimizationType) throws IOException {
        return FileUtils.getFile((File)this.getPageDir(pageId), (String[])new String[]{a, optimizationType.getName()});
    }

    public void erasePage(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                private Void a(String ... stringArray) {
                    String string2 = stringArray[0];
                    PageStoreStrategy.this.b(string2);
                    return null;
                }

                protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
                    String[] stringArray = (String[])objectArray;
                    1 var2_3 = this;
                    String string2 = stringArray[0];
                    var2_3.PageStoreStrategy.this.b(string2);
                    return null;
                }
            }.execute((Object[])new String[]{pageId});
            return;
        }
        this.b(pageId);
    }

    public void eraseTempPageData(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                private Void a(String ... stringArray) {
                    String string2 = stringArray[0];
                    PageStoreStrategy.this.a(string2);
                    return null;
                }

                protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
                    String[] stringArray = (String[])objectArray;
                    2 var2_3 = this;
                    String string2 = stringArray[0];
                    var2_3.PageStoreStrategy.this.a(string2);
                    return null;
                }
            }.execute((Object[])new String[]{pageId});
            return;
        }
        this.a(pageId);
    }

    private void a(String string2) {
        try {
            File file = this.getImageFile(string2, Page.ImageType.ORIGINAL);
            if (file.exists()) {
                FileUtils.deleteQuietly((File)file);
            }
            return;
        }
        catch (IOException iOException) {
            this.c.logException(iOException);
            return;
        }
    }

    private void b(String string2) {
        try {
            File file = this.getPageDir(string2);
            if (file.exists() && file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            }
            return;
        }
        catch (IOException iOException) {
            this.c.logException(iOException);
            return;
        }
    }
}

