/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final Pattern FILE_NAME_ANTIPATTERN = Pattern.compile("[\\\\|?*<\\\">+\\[\\]/':]", 2);
    private static final int MAX_FILE_NAME_LENGTH = 250;

    public static boolean isFileNameSafe(CharSequence name) {
        if (TextUtils.isEmpty((CharSequence)name) || name.length() > 250) {
            return false;
        }
        return !FILE_NAME_ANTIPATTERN.matcher(name).find();
    }

    public static File getExternalFilesDirOrShowError(Context context, String directoryName) throws IOException {
        File file = null;
        try {
            file = context.getExternalFilesDir(null);
        }
        catch (NullPointerException nullPointerException) {}
        if (file == null) {
            return FileUtils.fail();
        }
        File file2 = new File(file, directoryName);
        if (!file2.exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    public static File getExternalStorageDirOrShowError(Context context, String directoryName) throws IOException {
        File file = Environment.getExternalStorageDirectory();
        if (file == null) {
            return FileUtils.fail();
        }
        File file2 = new File(file, directoryName);
        if (!file2.exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    public static File getExternalCacheDirOrShowError(Context context, String directoryName) throws IOException {
        File file = context.getExternalCacheDir();
        if (file == null) {
            return FileUtils.fail();
        }
        File file2 = new File(file, directoryName);
        if (!file2.exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    public static boolean ensureDirExists(String directoryPath) {
        if (TextUtils.isEmpty((CharSequence)directoryPath)) {
            return false;
        }
        File file = new File(directoryPath);
        return file.exists() || file.mkdirs();
    }

    private static File fail() throws IOException {
        throw new IOException("can't get external directory");
    }
}

