/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.hardware.Camera;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class Utils {
    private static final int A4_AREA = 8699840;
    private static final double ASPECT_TOLERANCE = 0.1;

    public static boolean isFlashSupported(Camera.Parameters parameters) {
        if (parameters == null) {
            return false;
        }
        List list = parameters.getSupportedFlashModes();
        return list != null && !list.isEmpty() && (list.size() != 1 || !((String)list.get(0)).equals("off"));
    }

    public static Camera.Size getBestA4PictureSize(Camera.Parameters parameters) {
        Object object2;
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (Object object2 : parameters.getSupportedPictureSizes()) {
            int n2 = ((Camera.Size)object2).width * ((Camera.Size)object2).height;
            treeMap.put(n2, object2);
        }
        Camera.Size size = null;
        object2 = treeMap.ceilingEntry(8699840);
        if (object2 == null) {
            object2 = treeMap.floorEntry(8699840);
        }
        if (object2 != null) {
            size = (Camera.Size)object2.getValue();
        }
        return size;
    }

    public static Camera.Size getLargestPictureSize(Camera.Parameters parameters) {
        Camera.Size size = null;
        for (Camera.Size size2 : parameters.getSupportedPictureSizes()) {
            if (size == null) {
                size = size2;
                continue;
            }
            int n2 = size.width * size.height;
            if (size2.width * size2.height <= n2) continue;
            size = size2;
        }
        return size;
    }

    public static Camera.Size getLargestSizeWithAspectRatioMatch(List<Camera.Size> sizes, double targetAspect) {
        a a2 = new a(0);
        ArrayList<Camera.Size> arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size : sizes) {
            double d2 = (double)size.width / (double)size.height;
            if (!(Math.abs(targetAspect - d2) < 0.1)) continue;
            arrayList.add(size);
        }
        return Collections.max(arrayList, a2);
    }

    public static Camera.Size findByWidthAndHeight(Camera.Parameters parameters, int width, int height) {
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (size.width != width || size.height != height) continue;
            return size;
        }
        return null;
    }

    public static Camera.Size getBestAspectPictureSize(int displayOrientation, int width, int height, Camera.Parameters parameters, double closeEnough) {
        double d2 = (double)width / (double)height;
        Camera.Size size = null;
        double d3 = Double.MAX_VALUE;
        if (displayOrientation == 90 || displayOrientation == 270) {
            d2 = (double)height / (double)width;
        }
        List list = parameters.getSupportedPictureSizes();
        Collections.sort(list, Collections.reverseOrder(new a(0)));
        for (Camera.Size size2 : list) {
            double d4;
            double d5 = (double)size2.width / (double)size2.height;
            if (Math.abs(d4 - d2) < d3) {
                size = size2;
                d3 = Math.abs(d5 - d2);
            }
            if (!(d3 < closeEnough)) continue;
        }
        return size;
    }

    public static void enableContinuousFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            List<String> list = Utils.extractFocusModes(parameters);
            if (list.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
                return;
            }
            if (list.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
                return;
            }
            if (list.contains("auto")) {
                parameters.setFocusMode("auto");
            }
        }
    }

    public static void enableAutoFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Utils.extractFocusModes(parameters).contains("auto") && !parameters.getFocusMode().equals("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    private static List<String> extractFocusModes(Camera.Parameters parameters) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        List list = parameters.getSupportedFocusModes();
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    private static final class a
    implements Comparator<Camera.Size> {
        private a() {
        }

        private static int a(Camera.Size size, Camera.Size size2) {
            int n2 = size.width * size.height;
            int n3 = size2.width * size2.height;
            return n2 - n3;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

