/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.thread;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;

public class ExecutionUtils {
    private static final Handler MAIN_LOOPER_HANDLER = new Handler(Looper.getMainLooper());

    public static void ensureMainThread() throws IllegalStateException {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("Method must be called from the main thread");
        }
    }

    public static void runOnUIThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
            return;
        }
        MAIN_LOOPER_HANDLER.post(runnable);
    }

    public static void showToast(final Context context, final int messageRes) {
        ExecutionUtils.runOnUIThread(new Runnable(){

            @Override
            public final void run() {
                Toast.makeText((Context)context, (int)messageRes, (int)1).show();
            }
        });
    }
}

