/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private final ScanbotCameraView cameraView;
    private final SignificantMoveCatcher significantMoveCatcher;
    private final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove = 0L;
    private final AtomicLong captureInterval = new AtomicLong(1000L);
    private final Logger logger = LoggerProvider.getLogger();
    private long lastCapture = 0L;
    private AtomicBoolean capturing = new AtomicBoolean(false);
    private boolean ignoreBadAspectRatio = false;
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isAutoSnapEnabled = true;
    private AtomicBoolean isAutosnappingShooting = new AtomicBoolean(false);
    private AutoSnappingCallback autoSnappingCallback = AutoSnappingCallback.NULL;
    private final Runnable autosnappingShoot = new Runnable(){

        @Override
        public final void run() {
            boolean bl;
            boolean bl2 = bl = SystemClock.elapsedRealtime() - AutoSnappingController.this.lastSignificantMove <= 2000L;
            if (AutoSnappingController.this.isAutoSnapEnabled && !bl) {
                if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                    AutoSnappingController.this.cameraView.takePicture(true);
                    return;
                }
            } else {
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    };

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        return AutoSnappingController.attach(cameraView, contourDetectorFrameHandler);
    }

    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(cameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this.cameraView = cameraView;
        this.significantMoveCatcher = new SignificantMoveCatcher(cameraView.getContext().getApplicationContext());
        this.significantMoveListener = new e(0);
        cameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        cameraView.addPictureCallback(new d(0));
        cameraView.addCameraStateCallback(new a(0));
        cameraView.addTakePictureCallback(new b(0));
        contourDetectorFrameHandler.addResultHandler(new c(0));
    }

    private void onDetectionOK() {
        if (!this.isAutosnappingShooting.get()) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.post(this.autosnappingShoot);
        }
    }

    public void setEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float sensitivity) {
        this.logger.logMethod();
        float f2 = 1.0f - this.clamp(sensitivity);
        this.captureInterval.set((long)(f2 * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = ignoreBadAspectRatio;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        this.logger.logMethod();
        this.autoSnappingCallback = callback != null ? callback : AutoSnappingCallback.NULL;
    }

    private final class b
    implements net.doo.snap.camera.c {
        private b() {
        }

        @Override
        public final void a() {
        }

        @Override
        public final void b() {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    private final class e
    implements SignificantMoveListener {
        private e() {
        }

        @Override
        public final float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public final void onSignificantMove() {
            AutoSnappingController.this.lastSignificantMove = SystemClock.elapsedRealtime();
            if (AutoSnappingController.this.capturing.get() && AutoSnappingController.this.isAutosnappingShooting.get()) {
                AutoSnappingController.this.cameraView.continuousFocus();
                AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    private final class a
    implements net.doo.snap.camera.b {
        private a() {
        }

        @Override
        public final void a() {
            AutoSnappingController.this.capturing.set(true);
            AutoSnappingController.this.significantMoveCatcher.registerSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
        }

        @Override
        public final void b() {
            AutoSnappingController.this.significantMoveCatcher.unregisterSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
            AutoSnappingController.this.capturing.set(false);
            AutoSnappingController.this.lastCapture = 0L;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    private final class d
    implements PictureCallback {
        private d() {
        }

        @Override
        public final void onPictureTaken(byte[] image, int imageOrientation) {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    private final class c
    implements ContourDetectorFrameHandler.ResultHandler {
        private c() {
        }

        @Override
        public final boolean handleResult(ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
            AutoSnappingController.this.logger.logMethod();
            if ((detectedFrame.detectionResult == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && detectedFrame.detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get() && SystemClock.elapsedRealtime() - AutoSnappingController.this.lastCapture > AutoSnappingController.this.captureInterval.get()) {
                if (AutoSnappingController.this.lastCapture != 0L) {
                    c c2 = this;
                    c2.AutoSnappingController.this.mainThreadHandler.post(new Runnable(){

                        @Override
                        public final void run() {
                            AutoSnappingController.this.onDetectionOK();
                        }
                    });
                }
                AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
            }
            return false;
        }

        private void a() {
            AutoSnappingController.this.mainThreadHandler.post(new /* invalid duplicate definition of identical inner class */);
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public final boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

