/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.content.Context;
import java.util.HashMap;
import java.util.Locale;
import net.doo.snap.R;
import org.jetbrains.annotations.NotNull;

public enum DocumentType implements Cloneable
{
    ACADEMIA("academia"),
    ACCOUNTING("accounting"),
    APPLICATION("application"),
    BUSINESS_CARD("businesscard"),
    CASE_FILE("casefile"),
    CERTIFICATE("certificate"),
    CONFIRMATION("confirmation"),
    CONTRACT("contract"),
    DELIVERY_NOTE("deliverynote"),
    DISCOUNT("discount"),
    FORM("form"),
    HEALTH("health"),
    HOME("home"),
    INFO("info"),
    INVOICE("invoice"),
    MANUAL("manual"),
    OFFER("offer"),
    ORDER("order"),
    PAYMENT_REMINDER("paymentreminder"),
    PAY_SLIP("payslip"),
    POLICY("policy"),
    POWER_OFF_ATTORNEY("powerofattorney"),
    PRESS_RELEASE("pressrelease"),
    RECEIPT("receipt"),
    REPORT("report"),
    STATEMENT("statement"),
    STUDIES("studies"),
    TAC("tac"),
    TAX("tax"),
    TERMINATION("termination"),
    TICKET("ticket"),
    UNKNOWN("unknown"),
    WILL("will");

    private static String[] displayNames;
    private static Locale currentLocale;
    private final String mimeType;
    private static final HashMap<String, DocumentType> mimeTypeToDocType;

    private static String[] getDisplayNames(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        if (locale != currentLocale || displayNames == null) {
            currentLocale = locale;
            displayNames = context.getResources().getStringArray(R.array.document_types);
        }
        return displayNames;
    }

    private DocumentType(String mimeType) {
        this.mimeType = mimeType;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final String getDisplayName(Context context) {
        return DocumentType.getDisplayNames(context)[this.ordinal()];
    }

    @NotNull
    public static DocumentType getByMimeType(String mimeType) {
        if (mimeTypeToDocType.containsKey(mimeType)) {
            return mimeTypeToDocType.get(mimeType);
        }
        return UNKNOWN;
    }

    static {
        mimeTypeToDocType = new HashMap();
        for (DocumentType documentType : DocumentType.values()) {
            mimeTypeToDocType.put(documentType.getMimeType(), documentType);
        }
    }
}

