/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public enum Language {
    AFR("afr", "af"),
    ARA("ara", "ar"),
    AZE("aze", "az"),
    BEL("bel", "be"),
    BEN("ben", "bn"),
    BUL("bul", "bg"),
    CAT("cat", "ca"),
    CES("ces", "cs"),
    CHR("chr", "chr"),
    CHS("chi_sim", "zh-Hans"),
    CHT("chi_tra", "zh-Hant"),
    DAF("daf", "daf"),
    DAN("dan", "da"),
    DEF("def", "def"),
    DEU("deu", "de"),
    ELL("ell", "el"),
    ENG("eng", "en"),
    ENM("enm", "enm"),
    EPO("epo", "eo"),
    EQU("equ", "equ"),
    EST("est", "et"),
    EUS("eus", "eu"),
    FIN("fin", "fi"),
    FRA("fra", "fr"),
    FRK("frk", "frk"),
    FRM("frm", "frm"),
    GLG("glg", "gl"),
    GRC("grc", "grc"),
    HEB("heb", "he"),
    HIN("hin", "hi"),
    HRV("hrv", "hr"),
    HUN("hun", "hu"),
    IND("ind", "id"),
    ISL("isl", "is"),
    ITA("ita", "it"),
    JPN("jpn", "ja"),
    KAN("kan", "kn"),
    KOR("kor", "ko"),
    LAV("lav", "lv"),
    LIT("lit", "lt"),
    MAL("mal", "ml"),
    MKD("mkd", "mk"),
    MLT("mlt", "mt"),
    MSA("msa", "ms"),
    NDL("nld", "nl"),
    NOR("nor", "nb"),
    POL("pol", "pl"),
    POR("por", "pt"),
    RON("ron", "ro"),
    RUS("rus", "ru"),
    SLF("slf", "slf"),
    SLK("slk", "sk"),
    SLV("slv", "sl"),
    SPA("spa", "es"),
    SQI("sqi", "sq"),
    SRP("srp", "sr"),
    SWA("swa", "sw"),
    SWE("swe", "sv"),
    TAM("tam", "ta"),
    TEL("tel", "te"),
    TGL("tgl", "tl"),
    THA("tha", "th"),
    TUR("tur", "tr"),
    UKR("ukr", "uk"),
    VIE("vie", "vi");

    private static final HashMap<String, Language> isoToLanguage;
    private final String iso3Code;
    private final String iso1Code;

    public static Language languageByIso(String isoCode) {
        return isoToLanguage.get(isoCode);
    }

    public static String[] languageCodes(Collection<Language> languages) {
        String[] stringArray = new String[languages.size()];
        int n2 = 0;
        for (Language language : languages) {
            stringArray[n2] = language.getIsoCode();
            ++n2;
        }
        return stringArray;
    }

    private Language(@NotNull String iso3Code, String iso1Code) {
        this.iso3Code = iso3Code;
        this.iso1Code = iso1Code;
    }

    public final String getIsoCode() {
        return this.iso3Code;
    }

    public final String getIso1Code() {
        return this.iso1Code;
    }

    static {
        isoToLanguage = new HashMap();
        for (Language language : Language.values()) {
            isoToLanguage.put(language.getIsoCode(), language);
            isoToLanguage.put(language.getIso1Code(), language);
        }
        isoToLanguage.put("nob", NOR);
        isoToLanguage.put("zho", CHS);
    }
}

