/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> polygon) {
        return !polygon.isEmpty() && Math.abs(polygon.get((int)1).x - polygon.get((int)0).x) > 35 && Math.abs(polygon.get((int)2).x - polygon.get((int)3).x) > 35 && Math.abs(polygon.get((int)3).y - polygon.get((int)0).y) > 35 && Math.abs(polygon.get((int)2).y - polygon.get((int)1).y) > 35;
    }

    public void setRotation(int degrees) {
        if (this.rotation == degrees) {
            return;
        }
        this.rotation = degrees;
        this.matrix.setRotate((float)degrees, 0.5f, 0.5f);
    }

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLayout(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void polygonToPoints(List<PointF> polygon, float[] points) {
        int n2;
        for (n2 = 0; n2 < polygon.size(); ++n2) {
            this.tmpPoints[n2 * 2] = polygon.get((int)n2).x;
            this.tmpPoints[n2 * 2 + 1] = polygon.get((int)n2).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n2 = 0; n2 < polygon.size(); ++n2) {
            points[n2 * 4] = (float)this.left + (float)this.width * this.tmpPoints[n2 * 2];
            points[n2 * 4 + 1] = (float)this.top + (float)this.height * this.tmpPoints[n2 * 2 + 1];
            points[n2 * 4 + 2] = (float)this.left + (float)this.width * this.tmpPoints[(n2 * 2 + 2) % 8];
            points[n2 * 4 + 3] = (float)this.top + (float)this.height * this.tmpPoints[(n2 * 2 + 3) % 8];
        }
    }

    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        for (int i2 = 0; i2 < drawingPolygon.size(); ++i2) {
            PointF pointF = polygon.get(i2);
            PointF pointF2 = drawingPolygon.get(i2);
            drawingPolygon.get(i2).x = pointF.x * (float)this.width;
            pointF2.y = pointF.y * (float)this.height;
        }
    }

    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        for (int i2 = 0; i2 < drawingPolygon.size(); ++i2) {
            PointF pointF = polygon.get(i2);
            PointF pointF2 = drawingPolygon.get(i2);
            pointF.x = pointF2.x / (float)this.width;
            pointF.y = pointF2.y / (float)this.height;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> lines) {
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (Line2D line2D : lines) {
            var3_3.next().getStart().x = (float)this.left + (float)this.width * line2D.getStart().x;
            line2D.getStart().y = (float)this.top + (float)this.height * line2D.getStart().y;
            line2D.getEnd().x = (float)this.left + (float)this.width * line2D.getEnd().x;
            line2D.getEnd().y = (float)this.top + (float)this.height * line2D.getEnd().y;
            arrayList.add(line2D);
        }
        return arrayList;
    }
}

