/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.doo.snap.b.c;

public class GoogleVisionBarcodeDetector
implements ScanbotBarcodeDetector {
    private final SapManager sapManager;
    private final Context context;
    private BarcodeDetector detector;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);

    @Inject
    public GoogleVisionBarcodeDetector(Context context) {
        this.context = context;
        this.detector = new BarcodeDetector.Builder(context).build();
        this.sapManager = c.a(context);
    }

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(List<BarcodeFormat> barcodeFormats) {
        this.detector.release();
        int n2 = 0;
        for (BarcodeFormat barcodeFormat : barcodeFormats) {
            n2 |= this.getGVFormat(barcodeFormat);
        }
        this.detector = new BarcodeDetector.Builder(this.context).setBarcodeFormats(n2).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] data, int width, int height, int frameOrientation) {
        BarcodeScanningResult barcodeScanningResult = null;
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        if (this.detector == null || !this.detector.isOperational()) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(data);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, width, height, 17).build();
            SparseArray sparseArray = this.detector.detect(frame);
            if (sparseArray.size() > 0) {
                Barcode barcode = (Barcode)sparseArray.valueAt(0);
                barcodeScanningResult = new BarcodeScanningResult(barcode.rawValue, barcode.rawValue.getBytes(), this.getCornerPoints(barcode.cornerPoints), this.getAppFormat(barcode.format));
            }
        }
        finally {
            this.detector.release();
        }
        return barcodeScanningResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] data, int width, int height, int frameOrientation, Rect finderRect) {
        BarcodeScanningResult barcodeScanningResult = null;
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        if (this.detector == null || !this.detector.isOperational()) {
            return null;
        }
        try {
            int n2 = frameOrientation == 0 || frameOrientation == 180 ? width : height;
            int n3 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.width() : finderRect.height();
            int n4 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.height() : finderRect.width();
            int n5 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.left : finderRect.top;
            int n6 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.top : n2 - finderRect.right;
            Rect rect = new Rect(n5, n6, n5 + n3, n6 + n4);
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(data);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, width, height, 17).build();
            SparseArray sparseArray = this.detector.detect(frame);
            for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
                Barcode barcode = (Barcode)sparseArray.valueAt(i2);
                if (!rect.contains(barcode.getBoundingBox())) continue;
                barcodeScanningResult = new BarcodeScanningResult(barcode.rawValue, barcode.rawValue.getBytes(), this.getCornerPoints(barcode.cornerPoints), this.getAppFormat(barcode.format));
                break;
            }
        }
        finally {
            this.detector.release();
        }
        return barcodeScanningResult;
    }

    private ResultPoint[] getCornerPoints(Point[] cornerPoints) {
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        for (Point point : cornerPoints) {
            arrayList.add(new ResultPoint(point.x, point.y));
        }
        return arrayList.toArray(new ResultPoint[arrayList.size()]);
    }

    private BarcodeFormat getAppFormat(int googleVisionFormat) {
        switch (googleVisionFormat) {
            case 4096: {
                return BarcodeFormat.AZTEC;
            }
            case 8: {
                return BarcodeFormat.CODABAR;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 1: {
                return BarcodeFormat.CODE_128;
            }
            case 16: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 64: {
                return BarcodeFormat.EAN_8;
            }
            case 32: {
                return BarcodeFormat.EAN_13;
            }
            case 128: {
                return BarcodeFormat.ITF;
            }
            case 2048: {
                return BarcodeFormat.PDF_417;
            }
            case 256: {
                return BarcodeFormat.QR_CODE;
            }
            case 512: {
                return BarcodeFormat.UPC_A;
            }
            case 1024: {
                return BarcodeFormat.UPC_E;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private int getGVFormat(BarcodeFormat barcodeFormat) {
        switch (barcodeFormat) {
            case ALL_FORMATS: 
            case MAXICODE: 
            case RSS_14: 
            case RSS_EXPANDED: 
            case UPC_EAN_EXTENSION: 
            case UNKNOWN: {
                return 0;
            }
            case AZTEC: {
                return 4096;
            }
            case CODABAR: {
                return 8;
            }
            case CODE_39: {
                return 2;
            }
            case CODE_93: {
                return 4;
            }
            case CODE_128: {
                return 1;
            }
            case DATA_MATRIX: {
                return 16;
            }
            case EAN_8: {
                return 64;
            }
            case EAN_13: {
                return 32;
            }
            case ITF: {
                return 128;
            }
            case PDF_417: {
                return 2048;
            }
            case QR_CODE: {
                return 256;
            }
            case UPC_A: {
                return 512;
            }
            case UPC_E: {
                return 1024;
            }
        }
        return 0;
    }
}

