/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode.entity;

import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.ResultPoint;

public class BarcodeScanningResult
implements Parcelable {
    private final String text;
    private final byte[] rawBytes;
    private final int numBits;
    private ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private final long timestamp;
    public static final Parcelable.Creator<BarcodeScanningResult> CREATOR = new Parcelable.Creator<BarcodeScanningResult>(){

        public BarcodeScanningResult a(Parcel parcel) {
            return new BarcodeScanningResult(parcel);
        }

        public BarcodeScanningResult[] a(int n2) {
            return new BarcodeScanningResult[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public BarcodeScanningResult(String text, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format) {
        this(text, rawBytes, resultPoints, format, System.currentTimeMillis());
    }

    public BarcodeScanningResult(String text, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format, long timestamp) {
        this(text, rawBytes, rawBytes == null ? 0 : 8 * rawBytes.length, resultPoints, format, timestamp);
    }

    public BarcodeScanningResult(String text, byte[] rawBytes, int numBits, ResultPoint[] resultPoints, BarcodeFormat format, long timestamp) {
        this.text = text;
        this.rawBytes = rawBytes;
        this.numBits = numBits;
        this.resultPoints = resultPoints;
        this.format = format;
        this.timestamp = timestamp;
    }

    protected BarcodeScanningResult(Parcel in) {
        this.text = in.readString();
        this.rawBytes = in.createByteArray();
        this.numBits = in.readInt();
        this.resultPoints = (ResultPoint[])in.createTypedArray(ResultPoint.CREATOR);
        this.timestamp = in.readLong();
        this.format = BarcodeFormat.valueOf(in.readString());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.text);
        dest.writeByteArray(this.rawBytes);
        dest.writeInt(this.numBits);
        dest.writeTypedArray((Parcelable[])this.resultPoints, flags);
        dest.writeLong(this.timestamp);
        dest.writeString(this.format.name());
    }

    public int describeContents() {
        return 0;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public void addResultPoints(ResultPoint[] newPoints) {
        ResultPoint[] resultPointArray = this.resultPoints;
        if (resultPointArray == null) {
            this.resultPoints = newPoints;
        } else if (newPoints != null && newPoints.length > 0) {
            ResultPoint[] resultPointArray2 = new ResultPoint[resultPointArray.length + newPoints.length];
            System.arraycopy(resultPointArray, 0, resultPointArray2, 0, resultPointArray.length);
            System.arraycopy(newPoints, 0, resultPointArray2, resultPointArray.length, newPoints.length);
            this.resultPoints = resultPointArray2;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.text;
    }
}

