/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.inject.Inject;
import net.doo.snap.a.a;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.DocumentClassifier;
import net.doo.snap.persistence.BlobStoreStrategy;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class BlobFactory {
    private static final String LANGUAGE_CLASSIFIER_BIN = "languageClassifier2.bin";
    private static final String NATALIE_BIN = "natalie.bin";
    private static final String OSD = "osd.traineddata";
    private static final String[] OCR_ARABIC = new String[]{"ara.cube.bigrams", "ara.cube.fold", "ara.cube.lm", "ara.cube.nn", "ara.cube.params", "ara.cube.size", "ara.cube.word-freq", "ara.traineddata", "eng.cube.params", "fra.cube.params", "hin.cube.params", "ita.cube.params", "rus.cube.params", "spa.cube.params"};
    private static final String PDF_FONT = "pdf.ttf";
    private static final String BANKS_DATA_FILENAME = "banks.csv";
    private static final String MRZ_TRAINEDDATA_FILENAME = "ocrb.traineddata";
    private final BlobStoreStrategy blobStoreStrategy;
    private final a remoteStorage;
    private final DocumentClassifier documentClassifier;

    @Inject
    public BlobFactory(BlobStoreStrategy blobStoreStrategy, a remoteStorage, DocumentClassifier documentClassifier) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.remoteStorage = remoteStorage;
        this.documentClassifier = documentClassifier;
    }

    @NotNull
    public Collection<Blob> ocrLanguageBlobs(Language language) throws IOException {
        HashSet<Blob> hashSet = new HashSet<Blob>();
        File file = this.blobStoreStrategy.getOCRDataDirectory();
        String string2 = language.getIsoCode() + ".traineddata";
        Blob blob = new Blob(new File(file, string2).getPath(), this.remoteStorage.a(string2).toString());
        hashSet.add(blob);
        Blob blob2 = new Blob(new File(file, OSD).getPath(), this.remoteStorage.a(OSD).toString());
        hashSet.add(blob2);
        Blob blob3 = new Blob(new File(file, PDF_FONT).getPath(), PDF_FONT);
        hashSet.add(blob3);
        hashSet.addAll(this.ocrLanguageSpecificBlobs(language));
        return hashSet;
    }

    private Collection<? extends Blob> ocrLanguageSpecificBlobs(Language language) throws IOException {
        if (language != Language.ARA) {
            return Collections.emptySet();
        }
        File file = this.blobStoreStrategy.getOCRDataDirectory();
        HashSet<Blob> hashSet = new HashSet<Blob>();
        for (String string2 : OCR_ARABIC) {
            hashSet.add(new Blob(new File(file, string2).getPath(), this.remoteStorage.a(string2).toString()));
        }
        return hashSet;
    }

    @NotNull
    public Collection<Blob> languageDetectorBlobs() throws IOException {
        File file = this.blobStoreStrategy.getBinariesDirectory();
        String string2 = LANGUAGE_CLASSIFIER_BIN;
        Blob blob = new Blob(new File(file, LANGUAGE_CLASSIFIER_BIN).getPath(), this.remoteStorage.a().toString());
        return Arrays.asList(blob);
    }

    @NotNull
    public Collection<Blob> documentClassifierBlobs(Language language) throws IOException {
        if (!this.documentClassifier.isLanguageSupported(language)) {
            return Collections.emptyList();
        }
        File file = this.blobStoreStrategy.getDocumentClassifierDirectory();
        String string2 = NATALIE_BIN;
        Blob blob = new Blob(FileUtils.getFile((File)file, (String[])new String[]{language.getIsoCode(), NATALIE_BIN}).getPath(), this.remoteStorage.a(language.getIsoCode(), NATALIE_BIN).toString());
        return Arrays.asList(blob);
    }

    @NotNull
    public Blob bankDataBlob() throws IOException {
        File file = this.blobStoreStrategy.getBanksDataFile();
        return new Blob(file.getPath(), BANKS_DATA_FILENAME);
    }

    @NotNull
    public Blob mrzTraineddataBlob() throws IOException {
        File file = this.blobStoreStrategy.getMRZTraindataFile();
        return new Blob(file.getPath(), MRZ_TRAINEDDATA_FILENAME);
    }
}

