/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.c;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private static final int TAKE_PICTURE_DELAY_MS = 500;
    private CameraView cameraView;
    private net.doo.snap.camera.a cameraHost;
    private boolean resumed = false;
    private b state = b.a;
    private int lastMeasuredWidth;
    private int lastMeasuredHeight;
    private final Set<net.doo.snap.camera.b> stateCallbacks = new LinkedHashSet<net.doo.snap.camera.b>();
    private final Set<c> takePictureCallbacks = new LinkedHashSet<c>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        if (!io.scanbot.sdk.ScanbotSDKInitializer.a && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        if (!net.doo.snap.b.c.a(context).isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        this.cameraView = new CameraView(context);
        this.cameraHost = new net.doo.snap.camera.a(context);
        this.cameraView.setCameraHost((CameraHost)this.cameraHost);
        this.cameraView.a(new a());
        this.addView((View)this.cameraView, 0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.logger.logMethod();
        int n2 = ScanbotCameraView.resolveSize((int)this.lastMeasuredWidth, (int)widthMeasureSpec);
        int n3 = ScanbotCameraView.resolveSize((int)this.lastMeasuredHeight, (int)heightMeasureSpec);
        if (this.lastMeasuredWidth < n2 || this.lastMeasuredHeight < n3) {
            this.lastMeasuredWidth = n2;
            this.lastMeasuredHeight = n3;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)this.lastMeasuredWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec)), View.MeasureSpec.makeMeasureSpec((int)this.lastMeasuredHeight, (int)View.MeasureSpec.getMode((int)heightMeasureSpec)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.logger.logMethod();
        super.onLayout(changed, left, top, right, bottom);
        View view = this.cameraView.getChildAt(0);
        if (view == null) {
            return;
        }
        int n2 = this.getChildCount();
        int n3 = View.MeasureSpec.makeMeasureSpec((int)view.getWidth(), (int)Integer.MIN_VALUE);
        int n4 = View.MeasureSpec.makeMeasureSpec((int)view.getHeight(), (int)Integer.MIN_VALUE);
        for (int i2 = 1; i2 < n2; ++i2) {
            View view2 = this.getChildAt(i2);
            view2.measure(n3, n4);
            view2.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.b();
    }

    public void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = net.doo.snap.b.c.a(this.getContext()).isLicenseActive();
        this.state = b.a;
        this.cameraView.onResume();
        this.notifyResumedState();
    }

    public void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state = b.a;
        this.cameraView.onPause();
        this.notifyPausedState();
    }

    private void notifyResumedState() {
        for (net.doo.snap.camera.b b2 : this.stateCallbacks) {
            b2.a();
        }
    }

    private void notifyPausedState() {
        for (net.doo.snap.camera.b b2 : this.stateCallbacks) {
            b2.b();
        }
    }

    private void notifyTakePictureCancelled() {
        for (c c2 : this.takePictureCallbacks) {
            c2.b();
        }
    }

    public void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.stopPreview();
    }

    public void takePicture(boolean aquireFocus) {
        this.logger.logMethod();
        if (this.state != b.a) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
            if (!this.resumed) {
                return;
            }
        }
        if (aquireFocus) {
            this.state = b.b;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    private void performSnapping() {
        this.state = b.c;
        try {
            Camera.Parameters parameters = this.cameraView.getCameraParameters();
            PictureTransaction pictureTransaction = new PictureTransaction((CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (parameters != null) {
                pictureTransaction = pictureTransaction.flashMode(parameters.getFlashMode());
            }
            this.cameraView.takePicture(pictureTransaction);
        }
        catch (IllegalStateException illegalStateException) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
        }
    }

    public void useFlash(boolean useFlash) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (Utils.isFlashSupported(parameters)) {
            this.cameraView.setFlashMode(useFlash ? "torch" : "off");
        }
    }

    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.cameraView.a(autoFocusOnTouch);
    }

    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.a();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.a(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.b(pictureCallback);
    }

    void addCameraStateCallback(net.doo.snap.camera.b cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.add(cameraStateCallback);
    }

    void removeCameraStateCallback(net.doo.snap.camera.b cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.remove(cameraStateCallback);
    }

    void addTakePictureCallback(c cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.add(cameraTakePictureCallback);
    }

    void removeTakePictureCallback(c cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.remove(cameraTakePictureCallback);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraView.a(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size pictureSize) {
        this.logger.logMethod();
        this.cameraHost.a(pictureSize);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPictureSize(pictureSize.width, pictureSize.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setPreviewSize(Camera.Size previewSize) {
        this.logger.logMethod();
        this.cameraHost.b(previewSize);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPreviewSize(previewSize.width, previewSize.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setAutoFocusSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.a(enabled);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.b(enabled);
        this.cameraView.b(enabled);
    }

    public void setPreviewMode(CameraPreviewMode mode) {
        this.logger.logMethod();
        this.cameraHost.a(mode);
    }

    @Deprecated
    public void lockToPortrait() {
        this.logger.logMethod();
        this.cameraView.lockToPortrait();
    }

    @Deprecated
    public void lockToLandscape() {
        this.logger.logMethod();
        this.cameraView.lockToLandscape();
    }

    public void lockToPortrait(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToPortrait(lockPicture);
    }

    public void lockToLandscape(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToLandscape(lockPicture);
    }

    public void unlockOrientation() {
        this.logger.logMethod();
        this.cameraView.unlockOrientation();
    }

    private static enum b {
        a,
        b,
        c;

    }

    private class a
    implements CameraView.AutofocusCallback {
        private a() {
        }

        @Override
        public void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            ScanbotCameraView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ScanbotCameraView.this.state == b.b) {
                        ScanbotCameraView.this.performSnapping();
                    } else {
                        ScanbotCameraView.this.state = b.a;
                        ScanbotCameraView.this.notifyTakePictureCancelled();
                    }
                }
            }, 500L);
        }
    }
}

