/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.PolygonHelper;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "detectDocument", "generateFilteredPreview", "Landroid/graphics/Bitmap;", "rotate", "times", "", "rotateBitmap", "bitmap", "scanbot-sdk_release"})
public final class PageProcessor {
    private Context context;
    private final PageFileStorage pageFileStorage;

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        Bitmap bitmap3 = bitmap = contourDetector.processImageF(bitmap2, CollectionsKt.emptyList(), filter.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"filteredBitmap");
        this.pageFileStorage.setImageForId(bitmap3, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        return new Page(page.getPageId(), page.getPolygon(), page.getDetectionStatus(), filter);
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        Bitmap bitmap3 = bitmap = contourDetector.processImageAndRelease(bitmap2, CollectionsKt.emptyList(), filter.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"filteredBitmap");
        return this.pageFileStorage.generateAndSetFilteredPreviewForId(bitmap3, page.getPageId(), filter);
    }

    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        DetectionResult detectionResult = contourDetector.detect(bitmap);
        Bitmap bitmap2 = contourDetector.processImageF(bitmap, contourDetector.getPolygonF(), page.getFilter().getCode());
        Bitmap bitmap3 = page.getFilter() != ImageFilterType.NONE ? contourDetector.processImageF(bitmap, contourDetector.getPolygonF(), ImageFilterType.NONE.getCode()) : bitmap2;
        Bitmap bitmap4 = bitmap2;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"documentBitmap");
        this.pageFileStorage.setImageForId(bitmap4, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        Bitmap bitmap5 = bitmap3;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"unfilteredDocumentBitmap");
        this.pageFileStorage.setImageForId(bitmap5, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        String string2 = page.getPageId();
        List list = contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"detector.polygonF");
        DetectionResult detectionResult2 = detectionResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"detectionResult");
        return new Page(string2, list, detectionResult2, page.getFilter());
    }

    @NotNull
    public final Page rotate(@NotNull Page page, int times) throws IOException {
        Object object;
        Bitmap bitmap;
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        Bitmap bitmap3 = bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
        bitmap2 = this.rotateBitmap(bitmap3, times);
        this.pageFileStorage.setImageForId(bitmap2, page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        bitmap2.recycle();
        Uri uri2 = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        if (new File(uri2.getPath()).exists()) {
            Bitmap bitmap4 = bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"documentBitmap");
            bitmap = this.rotateBitmap(bitmap4, times);
            this.pageFileStorage.setImageForId(bitmap, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
            bitmap.recycle();
        }
        bitmap = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri2.getPath()).exists()) {
            object = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)bitmap);
            Bitmap bitmap5 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"unfilteredDocumentBitmap");
            object = this.rotateBitmap(bitmap5, times);
            this.pageFileStorage.setImageForId((Bitmap)object, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
            object.recycle();
        }
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        object = page.getPolygon();
        if (!object.isEmpty()) {
            object = PolygonHelper.Companion.rotatePolygon(page.getPolygon(), -1 * times * 90);
            return new Page(page.getPageId(), (List<? extends PointF>)object, page.getDetectionStatus(), page.getFilter());
        }
        return new Page(page.getPageId(), page.getPolygon(), page.getDetectionStatus(), page.getFilter());
    }

    private final Bitmap rotateBitmap(Bitmap bitmap, int times) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)(-1 * times * 90));
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026ap.height, matrix, false)");
        return bitmap2;
    }

    @Inject
    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
    }
}

