/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.DocumentClassifier;
import net.doo.snap.intelligence.d;
import net.doo.snap.intelligence.o;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public class c
implements Composer {
    private final Logger a = LoggerProvider.getLogger();
    private final DocumentStoreStrategy b;
    private final net.doo.snap.intelligence.a c;
    private final o d;
    private final BlobManager e;
    private final DocumentClassifier f;
    private final d g;
    private final PDFProcessor h;
    private final SimpleComposer i;
    private final SapManager j;

    @Inject
    public c(DocumentStoreStrategy documentStoreStrategy, net.doo.snap.intelligence.a a2, o o2, BlobManager blobManager, DocumentClassifier documentClassifier, d d2, PDFProcessor pDFProcessor, SimpleComposer simpleComposer, SapManager sapManager) {
        this.j = sapManager;
        this.b = documentStoreStrategy;
        this.c = a2;
        this.d = o2;
        this.e = blobManager;
        this.f = documentClassifier;
        this.g = d2;
        this.h = pDFProcessor;
        this.i = simpleComposer;
    }

    @Override
    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (!this.j.isLicenseActive() || !this.j.isFeatureEnabled(16)) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            long l2 = SystemClock.elapsedRealtime();
            this.a();
            Set<Language> set = this.e.getAllLanguagesWithAvailableOcrBlobs();
            Language language = this.d.a();
            if (!set.contains((Object)language)) {
                this.a.d("OCR", "Default language is not available - abort OCR: " + (Object)((Object)language));
                throw new IOException("Blob for default language is not available");
            }
            String string2 = this.a(document, pages, language, set);
            this.a(document, set, language, string2);
            this.a(document, l2);
        }
        catch (IOException iOException) {
            this.i.composeDocument(document, pages);
        }
    }

    private void a() throws IOException {
        if (this.e.hasActiveDownloads()) {
            throw new IOException("Downloading in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(Document document, Page[] pageArray, final Language language, Set<Language> set) throws IOException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    c.this.f.initialize(language);
                }
                catch (IOException iOException) {
                    c.this.a.logException(iOException);
                }
            }
        });
        try {
            String string2 = this.a(document, pageArray, set, language);
            this.h.processPDF(document, pageArray);
            String string3 = string2;
            return string3;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private String a(Document document, Page[] pageArray, Set<Language> set, Language language) throws IOException {
        String string2;
        this.a.d("OCR", "Starting OCR with language: " + (Object)((Object)language));
        try {
            string2 = this.b(document, pageArray, set, language);
        }
        catch (a a2) {
            string2 = this.a(document, pageArray, a2.a());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b(Document document, Page[] pageArray, Set<Language> set, Language language) throws IOException, a {
        String string2 = null;
        d.a a2 = this.g.a(document, pageArray, Collections.singletonList(language));
        try {
            boolean bl = false;
            while (a2.a()) {
                if (bl) continue;
                try {
                    HashSet<Language> hashSet = new HashSet<Language>(this.c.a(a2.b()));
                    this.a.d("OCR", "Detected languages: " + Arrays.toString(hashSet.toArray()));
                    hashSet.retainAll(set);
                    if (hashSet.isEmpty()) {
                        hashSet.addAll(set);
                        this.a.d("OCR", "None of them are available");
                    }
                    if (hashSet.size() == 1 && hashSet.contains((Object)language)) {
                        bl = true;
                        this.a.d("OCR", "Continue with current language");
                        continue;
                    }
                    this.a.d("OCR", "Languages are not match. Restart with languages: " + Arrays.toString(hashSet.toArray()));
                    throw new a(hashSet);
                }
                catch (IOException iOException) {
                    this.a.logException(iOException);
                    bl = true;
                }
            }
            string2 = a2.b();
        }
        finally {
            a2.h();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(Document document, Page[] pageArray, Collection<Language> collection) throws IOException {
        File file = this.b.getDocumentFile(document.getId(), document.getName());
        FileUtils.deleteQuietly((File)file);
        d.a a2 = this.g.a(document, pageArray, collection);
        try {
            while (a2.a()) {
            }
            String string2 = a2.b();
            return string2;
        }
        finally {
            a2.h();
        }
    }

    private void a(Document document, Set<Language> set, Language language, String string2) throws IOException {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(string2);
        this.a(document, string2, set, language);
        this.a(document, string2);
        this.a(document);
    }

    private void a(Document document, String string2, Set<Language> set, Language language) throws IOException {
        ArrayList<Language> arrayList = new ArrayList<Language>(this.c.a(string2));
        arrayList.retainAll(set);
        arrayList.add(language);
        document.setLanguage((Language)((Object)arrayList.get(0)));
    }

    private void a(Document document, String string2) {
        Language language = document.getLanguage();
        if (language == null) {
            return;
        }
        try {
            DocumentType documentType = this.f.classifyDocument(language, string2);
            document.setDocumentType(documentType);
        }
        catch (IOException iOException) {
            this.a.logException(iOException);
        }
    }

    private void a(Document document, long l2) {
        if (document.getLanguage() == null) {
            return;
        }
        long l3 = SystemClock.elapsedRealtime() - l2;
        this.a.d("OCR", "Ocr total: " + (float)l3 / 1000.0f + " sec");
    }

    private void a(Document document) {
        if (document.getLanguage() != null) {
            this.a.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }

    private static class a
    extends Exception {
        private final Collection<Language> a;

        public a(Collection<Language> collection) {
            this.a = collection;
        }

        public Collection<Language> a() {
            return this.a;
        }
    }
}

