/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.persistence.b;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    public static final String a = "thumbnail";
    public static final String b = "snapping_documents";
    private static final String c = "%s(%d)%s";
    private static final String d = " (1).";
    private final Context e;
    private final SharedPreferences f;
    private final Logger g = LoggerProvider.getLogger();

    @Inject
    public DocumentStoreStrategy(Context context, SharedPreferences sharedPreferences) {
        this.e = context;
        this.f = sharedPreferences;
    }

    public boolean ensureDocumentDir(File file) {
        return file != null && file.exists() && (this = file.listFiles()) != null && this.length >= 1;
    }

    public File getDocumentsDir() throws IOException {
        String string = this.f.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!string.isEmpty()) {
            return net.doo.snap.util.FileUtils.getFilesDirOrShowError(string, b);
        }
        return net.doo.snap.util.FileUtils.getFilesDirOrShowError(net.doo.snap.util.FileUtils.getAppFilesDirOrShowError(this.e, "scanbot-sdk").getPath(), b);
    }

    public File getDocumentDir(String string) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{string});
    }

    public void ensureDocumentDirectory(String string) throws IOException {
        FileUtils.forceMkdir((File)this.getDocumentDir(string));
    }

    public File getDocumentFile(String string, String string2) throws IOException {
        return FileUtils.getFile((File)this.getDocumentDir(string), (String[])new String[]{string2});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        File[] fileArray = this.getDocumentsDir().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.addAll(Arrays.asList(fileArray[i2].listFiles(new b(this))));
        }
        return arrayList2;
    }

    public File getThumbnailFile(String string) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{string, a});
    }

    public void eraseDocument(String string, String string2) {
        try {
            FileUtils.deleteQuietly((File)this.getDocumentFile(string, string2));
            FileUtils.deleteQuietly((File)this.getDocumentDir(string));
        }
        catch (IOException iOException) {
            this.g.logException(iOException);
        }
    }

    public void eraseDocumentThumbnail(String string) {
        try {
            FileUtils.deleteQuietly((File)this.getThumbnailFile(string));
        }
        catch (IOException iOException) {
            this.g.logException(iOException);
        }
    }

    public boolean renameDocument(String string, String string2, String string3) throws IOException {
        DocumentStoreStrategy documentStoreStrategy = file;
        File file = ((DocumentStoreStrategy)((Object)file)).getDocumentFile(string, ((DocumentStoreStrategy)((Object)file)).getUniqueName(string3));
        return documentStoreStrategy.getDocumentFile(string, string2).renameTo(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUniqueName(String string) {
        while (true) {
            Object object;
            Integer n2;
            Object object2;
            String string2;
            String string3;
            block11: {
                string3 = TextUtils.isEmpty((CharSequence)(string3 = FilenameUtils.getExtension((String)string))) ? "" : "." + string3;
                string2 = FilenameUtils.getBaseName((String)string);
                int n3 = string2.lastIndexOf("(");
                int n4 = string2.lastIndexOf(")");
                Integer n5 = 0;
                object2 = FilenameUtils.getBaseName((String)string);
                if (n3 >= 0 && n4 >= 0 && n4 > n3) {
                    block10: {
                        String string4 = string2;
                        try {
                            n2 = Integer.valueOf(string4.substring(n3 + 1, n4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = n5;
                            break block10;
                        }
                        try {
                            object = string4.substring(0, n3 - 1);
                            break block11;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    object = object2;
                } else {
                    n2 = n5;
                    object = object2;
                }
            }
            boolean bl = false;
            try {
                block12: {
                    object2 = this.getDocumentsFiles().iterator();
                    while (object2.hasNext()) {
                        if (!FilenameUtils.getBaseName((String)((File)object2.next()).getName()).equals(string2)) continue;
                        string3 = (String)object + " (" + (n2 + 1) + ")" + string3;
                        bl = true;
                        break block12;
                    }
                    string3 = string;
                }
                if (!bl) return string3;
                string = string3;
            }
            catch (IOException iOException) {
                this.g.logException(iOException);
                return string;
            }
        }
    }

    public String getPageImagePath(int n2, Document document) throws IOException {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = FilenameUtils.removeExtension((String)this.getDocumentFile(document.getId(), document.getName()).getPath());
        objectArray[1] = n2;
        objectArray[2] = ".jpg";
        return String.format(c, objectArray2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void migrateDocuments(String string, List<Document> list) {
        boolean bl = TextUtils.isEmpty((CharSequence)string) ^ true;
        Iterator<Document> iterator = list.iterator();
        while (iterator.hasNext()) {
            File file;
            Document document = iterator.next();
            String string2 = document.getName();
            String string3 = document.getId();
            if (bl) {
                File file2;
                file = file2;
                file2 = new File(string);
            } else {
                file = this.getDocumentDir(string3);
            }
            if (FileUtils.getFile((File)file, (String[])new String[]{string2}).exists()) {
                String string4 = string2;
                string2 = FilenameUtils.getExtension((String)string4);
                String string5 = FilenameUtils.getBaseName((String)string4);
                string2 = string5 + d + string2;
                this.renameDocument(string3, string4, string2);
            }
            FileUtils.moveFileToDirectory((File)this.getDocumentFile(string3, string2), (File)file, (boolean)true);
            {
                catch (Throwable throwable) {
                }
                catch (IOException iOException) {}
                {
                    this.g.logException(iOException);
                }
                continue;
            }
            break;
        }
        return;
    }
}

