/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.persistence.PolygonHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private final ScanbotCameraView cameraView;
    private final SignificantMoveCatcher significantMoveCatcher;
    private final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove = 0L;
    private final AtomicLong captureInterval = new AtomicLong(1000L);
    private final Logger logger = LoggerProvider.getLogger();
    private long lastCapture = 0L;
    private AtomicBoolean capturing = new AtomicBoolean(false);
    private boolean ignoreBadAspectRatio = false;
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isAutoSnapEnabled = true;
    private AtomicBoolean isAutosnappingShooting = new AtomicBoolean(false);
    private AutoSnappingCallback autoSnappingCallback = AutoSnappingCallback.NULL;
    private final Runnable autosnappingShoot = new Runnable(){

        @Override
        public void run() {
            boolean bl;
            boolean bl2 = bl = SystemClock.elapsedRealtime() - AutoSnappingController.this.lastSignificantMove <= 2000L;
            if (AutoSnappingController.this.isAutoSnapEnabled && !bl) {
                if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                    AutoSnappingController.this.cameraView.takePicture(true);
                }
            } else {
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    };

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        return AutoSnappingController.attach(cameraView, contourDetectorFrameHandler);
    }

    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(cameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this.cameraView = cameraView;
        this.significantMoveCatcher = new SignificantMoveCatcher(cameraView.getContext().getApplicationContext());
        this.significantMoveListener = new e();
        cameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        cameraView.addPictureCallback(new d());
        cameraView.addCameraStateCallback(new a());
        cameraView.addTakePictureCallback(new b());
        contourDetectorFrameHandler.addResultHandler(new c());
    }

    private void onDetectionOK() {
        if (!this.isAutosnappingShooting.get()) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.post(this.autosnappingShoot);
        }
    }

    public void setEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float sensitivity) {
        this.logger.logMethod();
        float f2 = 1.0f - this.clamp(sensitivity);
        this.captureInterval.set((long)(f2 * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = ignoreBadAspectRatio;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        this.logger.logMethod();
        this.autoSnappingCallback = callback != null ? callback : AutoSnappingCallback.NULL;
    }

    private class b
    implements net.doo.snap.camera.c {
        private b() {
        }

        @Override
        public void a() {
        }

        @Override
        public void b() {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class e
    implements SignificantMoveListener {
        private e() {
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            AutoSnappingController.this.lastSignificantMove = SystemClock.elapsedRealtime();
            if (AutoSnappingController.this.capturing.get() && AutoSnappingController.this.isAutosnappingShooting.get()) {
                AutoSnappingController.this.cameraView.continuousFocus();
                AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    }

    private class a
    implements net.doo.snap.camera.b {
        private a() {
        }

        @Override
        public void a() {
            AutoSnappingController.this.capturing.set(true);
            AutoSnappingController.this.significantMoveCatcher.registerSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
        }

        @Override
        public void b() {
            AutoSnappingController.this.significantMoveCatcher.unregisterSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
            AutoSnappingController.this.capturing.set(false);
            AutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class d
    implements PictureCallback {
        private d() {
        }

        @Override
        public void onPictureTaken(byte[] image, int imageOrientation) {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class c
    implements ContourDetectorFrameHandler.ResultHandler {
        private c() {
        }

        @Override
        public boolean handleResult(ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
            AutoSnappingController.this.logger.logMethod();
            if ((detectedFrame.detectionResult == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && detectedFrame.detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get()) {
                if (detectedFrame.finderRect != null && !detectedFrame.finderRect.isEmpty()) {
                    int n2;
                    List<PointF> list = PolygonHelper.rotatePolygon(detectedFrame.polygon, detectedFrame.frameOrientation);
                    int n3 = detectedFrame.frameOrientation % 180 == 0 ? detectedFrame.frameWidth : detectedFrame.frameHeight;
                    Rect rect = new Rect((int)(list.get((int)0).x * (float)n3), (int)(list.get((int)0).y * (float)(n2 = detectedFrame.frameOrientation % 180 == 0 ? detectedFrame.frameHeight : detectedFrame.frameWidth)), (int)(list.get((int)2).x * (float)n3), (int)(list.get((int)2).y * (float)n2));
                    if (!detectedFrame.finderRect.contains(rect)) {
                        return false;
                    }
                }
                if (SystemClock.elapsedRealtime() - AutoSnappingController.this.lastCapture > AutoSnappingController.this.captureInterval.get()) {
                    if (AutoSnappingController.this.lastCapture != 0L) {
                        this.a();
                    }
                    AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                }
            }
            return false;
        }

        private void a() {
            AutoSnappingController.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    AutoSnappingController.this.onDetectionOK();
                }
            });
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

