/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.a;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.TextRecognition;
import org.jetbrains.annotations.NotNull;

public final class b
implements OpticalCharacterRecognizer {
    private final TextRecognition a;
    private final PageFactory b;
    private final BlobManager c;
    private final PageFileStorage d;

    private final Document a() {
        Document document;
        Document document2 = document;
        new Document().setId(UUID.randomUUID().toString());
        document2.setName(document2.getId() + ".pdf");
        document2.setOcrStatus(OcrStatus.PENDING);
        return document2;
    }

    private final void a(Set<? extends Language> set) {
        if (!((this = SetsKt.minus(set, ((b)this).getInstalledLanguages())).isEmpty() ^ true)) {
            return;
        }
        throw new a(this + " Provided set of languages was not presented on device");
    }

    @Inject
    public b(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.a = textRecognition;
        this.b = pageFactory;
        this.c = blobManager;
        this.d = pageFileStorage;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> object, @NotNull Set<? extends Language> set) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        b b2 = this;
        Set<Language> set2 = set;
        Intrinsics.checkParameterIsNotNull(object, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull(set2, (String)"languages");
        b2.a(set2);
        TextRecognition textRecognition = b2.a;
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Uri uri = (Uri)object.next();
            arrayList2.add(this.b.buildPage(new File(uri.getPath())));
        }
        OcrResult ocrResult = textRecognition.withoutPDF(arrayList2, set).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> object, @NotNull Set<? extends Language> set) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        b b2 = this;
        Set<Language> set2 = set;
        Intrinsics.checkParameterIsNotNull(object, (String)"pages");
        Intrinsics.checkParameterIsNotNull(set2, (String)"languages");
        b2.a(set2);
        TextRecognition textRecognition = b2.a;
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Page page = (Page)object.next();
            net.doo.snap.entity.Page page2 = this.b.buildPage(page.getPageId(), new File(this.d.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setOptimizationType(ImageFilterType.Companion.convertFilterTypeToOptimizationType(page.getFilter()));
            arrayList2.add(page2);
        }
        OcrResult ocrResult = textRecognition.withoutPDF(arrayList2, set).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> object, @NotNull PDFPageSize pDFPageSize, @NotNull Set<? extends Language> set) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        b b2 = this;
        Set<Language> set2 = set;
        Intrinsics.checkParameterIsNotNull(object, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pDFPageSize), (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(set2, (String)"languages");
        b2.a(set2);
        TextRecognition textRecognition = b2.a;
        Document document = b2.a();
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Uri uri = (Uri)object.next();
            net.doo.snap.entity.Page page = this.b.buildPage(new File(uri.getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"oldPage");
            page.setPageSize(pDFPageSize);
            arrayList2.add(page);
        }
        OcrResult ocrResult = textRecognition.withPDF(document, arrayList2, set).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> object, @NotNull PDFPageSize pDFPageSize, @NotNull Set<? extends Language> set) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        b b2 = this;
        Set<Language> set2 = set;
        Intrinsics.checkParameterIsNotNull(object, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pDFPageSize), (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(set2, (String)"languages");
        b2.a(set2);
        TextRecognition textRecognition = b2.a;
        Document document = b2.a();
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            net.doo.snap.entity.Page page;
            Page page2 = (Page)object.next();
            net.doo.snap.entity.Page page3 = page = this.b.buildPage(page2.getPageId(), new File(this.d.getImageURI(page2.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page3, (String)"oldPage");
            page3.setOptimizationType(ImageFilterType.Companion.convertFilterTypeToOptimizationType(page2.getFilter()));
            page.setPolygon(page2.getPolygon());
            page.setPageSize(pDFPageSize);
            arrayList2.add(page);
        }
        OcrResult ocrResult = textRecognition.withPDF(document, arrayList2, set).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        File file = this.c.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        Set<Language> set = this.c.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }
}

