/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.R;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.ui.MagnifierView;
import net.doo.snap.ui.c;
import net.doo.snap.ui.d;
import net.doo.snap.ui.e;
import net.doo.snap.ui.f;
import net.doo.snap.ui.g;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    public static final List<PointF> DEFAULT_POLYGON = new net.doo.snap.ui.a();
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<b> horizontalLines = new ArrayList<b>();
    private final List<b> verticalLines = new ArrayList<b>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<a> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private a selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue;
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix;
    private RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;

    public static List<PointF> getDefaultPolygon() {
        return new net.doo.snap.ui.b();
    }

    public EditPolygonImageView(Context context, AttributeSet object) {
        super(context, object);
        int n2;
        c c2;
        c c3 = c2;
        c2 = new c(this);
        this.pointsQueue = new PriorityQueue<PointF>(4, c3);
        this.imageMatrix = new float[9];
        this.touchRect = new RectF();
        this.lastKnownImageWidth = -1;
        this.lastKnownImageHeight = -1;
        this.scaleLandscape = 1.0f;
        this.scalePortrait = 1.0f;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        EditPolygonImageView editPolygonImageView = this;
        context = context.getTheme().obtainStyledAttributes(object, R.styleable.EditPolygonImageView, 0, 0);
        EditPolygonImageView editPolygonImageView2 = this;
        Context context2 = context;
        EditPolygonImageView editPolygonImageView3 = this;
        Context context3 = context;
        EditPolygonImageView editPolygonImageView4 = this;
        Context context4 = context;
        EditPolygonImageView editPolygonImageView5 = this;
        Context context5 = context;
        EditPolygonImageView editPolygonImageView6 = this;
        Context context6 = context;
        EditPolygonImageView editPolygonImageView7 = this;
        Context context7 = context;
        EditPolygonImageView editPolygonImageView8 = this;
        Context context8 = context;
        int n3 = R.styleable.EditPolygonImageView_edgeColor;
        try {
            editPolygonImageView8.edgeColor = context8.getColor(n3, 0);
            editPolygonImageView7.edgeColorOnLine = context7.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, this.edgeColor);
            editPolygonImageView6.cornerDrawable = context6.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            editPolygonImageView5.edgeDrawable = context5.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            editPolygonImageView4.magneticLineTreshold = context4.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            editPolygonImageView3.polygonStrokeWidth = context3.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            editPolygonImageView2.handleSize = context2.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        context.recycle();
        editPolygonImageView.polygon = Collections.emptyList();
        editPolygonImageView.paint = new Paint();
        editPolygonImageView.paint.setColor(this.edgeColor);
        editPolygonImageView.paint.setStyle(Paint.Style.STROKE);
        editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paint.setAntiAlias(true);
        editPolygonImageView.paint.setStrokeCap(Paint.Cap.SQUARE);
        editPolygonImageView.paintOnLine = new Paint();
        editPolygonImageView.paintOnLine.setColor(this.edgeColorOnLine);
        editPolygonImageView.paintOnLine.setStyle(Paint.Style.STROKE);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paintOnLine.setAntiAlias(true);
        editPolygonImageView.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
        editPolygonImageView.handlePaint = new Paint();
        editPolygonImageView.handlePaint.setAntiAlias(true);
        editPolygonImageView.handlePaint.setFilterBitmap(true);
        editPolygonImageView.polygonHelper = new PolygonHelper();
        editPolygonImageView.corners = new ArrayList<PointF>();
        for (n2 = 0; n2 < 4; ++n2) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<a>();
        n2 = 0;
        while (n2 < this.corners.size()) {
            a a2;
            object = a2;
            super(null);
            a.a((a)object, this.corners.get(n2));
            int n4 = n2 + 1;
            a.b((a)object, this.corners.get(n4 % 4));
            a.c((a)object, this.corners.get((n2 + 3) % 4));
            a.d(a2, this.corners.get((n2 + 2) % 4));
            this.edges.add((a)object);
            n2 = n4;
        }
        return;
    }

    private float getRotationScale(float f2, float f3) {
        if (Math.abs((f2 + f3) % 360.0f) / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    private void drawHandle(Canvas canvas, PointF pointF, Bitmap bitmap, float f2) {
        canvas.save();
        if (f2 != 0.0f) {
            canvas.rotate(f2, pointF.x, pointF.y);
        }
        Canvas canvas2 = canvas;
        EditPolygonImageView editPolygonImageView = this;
        float f3 = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
        canvas.scale(f3, f3, pointF.x, pointF.y);
        canvas2.drawBitmap(bitmap, pointF.x - (float)(bitmap.getWidth() >> 1), pointF.y - (float)(bitmap.getHeight() >> 1), this.handlePaint);
        canvas2.restore();
    }

    private void keepInsideView(PointF pointF) {
        PointF pointF2 = pointF;
        pointF2.set(Math.max(0.0f, Math.min(pointF2.x, (float)this.getWidth() - this.offsetX * 2.0f)), Math.max(0.0f, Math.min(pointF.y, (float)this.getHeight() - this.offsetY * 2.0f)));
    }

    private void restoreSelectedEdge() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.selectedEdge.a.set(this.tmpPointA);
        editPolygonImageView.selectedEdge.b.set(this.tmpPointB);
        editPolygonImageView.selectedEdge.e.a(this.selectedEdge.a, this.selectedEdge.b);
    }

    private void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f4 = f3;
            PointF pointF = this.corners.get(i2);
            f3 = f2 + pointF.x;
            f2 = f4 + pointF.y;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        int n2 = 0;
        while (n2 < 4) {
            a a2 = this.edges.get(n2);
            a.a(a2, this.corners.get(n2));
            int n3 = n2 + 1;
            a.b(a2, this.corners.get(n3 % 4));
            a.c(a2, this.corners.get((n2 + 3) % 4));
            a.d(a2, this.corners.get((n2 + 2) % 4));
            n2 = n3;
        }
    }

    private void onImageSizeUpdated() {
        if (this.getDrawable() != null) {
            float f2;
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.offsetX = 0.0f;
            editPolygonImageView.offsetY = 0.0f;
            editPolygonImageView.getImageMatrix().getValues(this.imageMatrix);
            Drawable drawable = editPolygonImageView.getDrawable();
            int n2 = drawable.getIntrinsicHeight();
            float f3 = drawable.getIntrinsicWidth();
            EditPolygonImageView editPolygonImageView2 = this;
            float f4 = f3 * this.getScaleX();
            float f5 = n2;
            float f6 = f5 * this.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f4, f6);
            editPolygonImageView2.scalePortrait = io.scanbot.sdk.b.b.a((View)editPolygonImageView2, 0.0f, rectF) * this.getScaleX();
            editPolygonImageView2.scaleLandscape = io.scanbot.sdk.b.b.a((View)editPolygonImageView2, 90.0f, rectF) * this.getScaleY();
            if (f2 * editPolygonImageView2.scalePortrait < (float)this.getWidth()) {
                this.offsetX = this.getWidth() - (int)(f3 * this.scalePortrait) >> 1;
            }
            if (f5 * this.scalePortrait < (float)this.getHeight()) {
                this.offsetY = this.getHeight() - (int)(f5 * this.scalePortrait) >> 1;
            }
            EditPolygonImageView editPolygonImageView3 = this;
            f4 = this.scalePortrait;
            editPolygonImageView3.polygonHelper.setImageSize((int)(f3 * f4), (int)(f5 * f4));
            editPolygonImageView3.scaleLandscape /= this.scalePortrait;
            editPolygonImageView3.scalePortrait = 1.0f;
            if (editPolygonImageView3.getRotation() / 90.0f % 2.0f == 1.0f) {
                EditPolygonImageView editPolygonImageView4 = this;
                editPolygonImageView4.setScaleX(editPolygonImageView4.scaleLandscape);
                editPolygonImageView4.setScaleY(editPolygonImageView4.scaleLandscape);
            }
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    static /* synthetic */ float access$000(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.medianY;
    }

    static /* synthetic */ float access$100(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.medianX;
    }

    static /* synthetic */ List access$702(EditPolygonImageView editPolygonImageView, List list) {
        editPolygonImageView.polygon = list;
        return list;
    }

    static /* synthetic */ List access$800(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.corners;
    }

    static /* synthetic */ PolygonHelper access$900(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.polygonHelper;
    }

    static /* synthetic */ List access$1000(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.horizontalLines2D;
    }

    static /* synthetic */ List access$1100(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.horizontalLines;
    }

    static /* synthetic */ List access$1300(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.verticalLines2D;
    }

    static /* synthetic */ List access$1400(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.verticalLines;
    }

    static /* synthetic */ MagnifierView access$1500(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.magnifierView;
    }

    static /* synthetic */ EditPolygonAnimationEndListener access$1600(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.editPolygonAnimationEndListener;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        editPolygonImageView.cornerBitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.cornerDrawable);
        editPolygonImageView.edgeBitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        editPolygonImageView.cornerBitmap.recycle();
        editPolygonImageView.edgeBitmap.recycle();
        editPolygonImageView.editPolygonAnimationEndListener = null;
    }

    protected void onMeasure(int n2, int n3) {
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure(n2, n3);
        editPolygonImageView.onImageSizeUpdated();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
    }

    public void setPolygon(List<PointF> list) {
        this.post(new d(this, list));
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        }
        return this.polygon;
    }

    public void setRotation(float f2) {
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        float f3 = editPolygonImageView.getRotation() - f2;
        f3 = editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), f3);
        MagnifierView magnifierView = editPolygonImageView.magnifierView;
        if (magnifierView != null) {
            magnifierView.setImageRotation(f2);
        }
        EditPolygonImageView editPolygonImageView2 = this;
        this.setScaleX(f3);
        editPolygonImageView2.setScaleY(f3);
        editPolygonImageView2.invalidate();
        super.setRotation(f2);
    }

    public void setLines(List<Line2D> list, List<Line2D> list2) {
        this.post(new e(this, list, list2));
    }

    public void setEdgeColor(int n2) {
        this.paint.setColor(n2);
    }

    public void setEdgeColorOnLine(int n2) {
        this.paintOnLine.setColor(n2);
    }

    public void setEdgeWidth(float f2) {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = f2;
        editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, 90.0f);
        editPolygonImageView.animate().rotationBy(90.0f).scaleX(f2).scaleY(f2).setListener((Animator.AnimatorListener)new f(this)).start();
    }

    public void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, -90.0f);
        editPolygonImageView.animate().rotationBy(-90.0f).scaleX(f2).scaleY(f2).setListener((Animator.AnimatorListener)new g(this)).start();
    }

    protected void dispatchDraw(Canvas canvas) {
        EditPolygonImageView editPolygonImageView = this;
        super.dispatchDraw(canvas);
        editPolygonImageView.checkWhetherImageSizeUpdated();
        if (!editPolygonImageView.polygon.isEmpty()) {
            canvas.save();
            canvas.translate(this.offsetX, this.offsetY);
            for (a a2 : this.edges) {
                float f2 = ((a)a2).a.x;
                float f3 = ((a)a2).a.y;
                float f4 = ((a)a2).b.x;
                float f5 = ((a)a2).b.y;
                Paint paint = a2.k ? this.paintOnLine : this.paint;
                canvas.drawLine(f2, f3, f4, f5, paint);
            }
            Object object = this.selectedCorner;
            if (object != null) {
                this.drawHandle(canvas, (PointF)object, this.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    pointF = new PointF(this.selectedCorner.x / ((float)this.getWidth() - this.offsetX * 2.0f), this.selectedCorner.y / ((float)this.getHeight() - this.offsetY * 2.0f));
                    this.magnifierView.drawMagnifier((PointF)object);
                }
                canvas.restore();
            } else {
                object = this.selectedEdge;
                if (object != null) {
                    this.drawHandle(canvas, ((a)object).b(), this.edgeBitmap, this.selectedEdge.a());
                } else {
                    for (a a3 : this.edges) {
                        this.drawHandle(canvas, a3.b(), this.edgeBitmap, a3.a());
                    }
                    object = this.corners.iterator();
                    while (object.hasNext()) {
                        this.drawHandle(canvas, (PointF)object.next(), this.cornerBitmap, 0.0f);
                    }
                }
            }
            canvas.restore();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent object) {
        Line2D line2D;
        double d2;
        float f2;
        block20: {
            switch (object.getAction()) {
                default: {
                    return super.onTouchEvent((MotionEvent)object);
                }
                case 2: {
                    PointF pointF = this.selectedCorner;
                    if (pointF != null) {
                        EditPolygonImageView editPolygonImageView = this;
                        pointF.set(object.getX() - this.offsetX, object.getY() - this.offsetY);
                        editPolygonImageView.keepInsideView(editPolygonImageView.selectedCorner);
                        editPolygonImageView.ensureNoPolygonIntersection();
                        editPolygonImageView.invalidate();
                        return true;
                    }
                    if (this.selectedEdge == null) return true;
                    EditPolygonImageView editPolygonImageView = this;
                    Object object2 = object;
                    float f3 = object2.getX() - this.selectedEdge.i;
                    f2 = object2.getY() - this.selectedEdge.j;
                    editPolygonImageView.finger.offset(f3, f2);
                    editPolygonImageView.tmpPointA.set(this.selectedEdge.a);
                    editPolygonImageView.tmpPointB.set(this.selectedEdge.b);
                    d2 = Double.MAX_VALUE;
                    line2D = null;
                    if (editPolygonImageView.selectedEdge.c()) {
                        break;
                    }
                    for (int i2 = 0; i2 < this.verticalLines.size(); ++i2) {
                        double d3;
                        double d4 = this.verticalLines.get(i2).a(this.finger);
                        if (d3 < d2) {
                            line2D = this.verticalLines2D.get(i2);
                        } else {
                            d4 = d2;
                        }
                        d2 = d4;
                    }
                    break block20;
                }
                case 1: 
                case 3: {
                    this.selectedCorner = null;
                    this.selectedEdge = null;
                    object = this.magnifierView;
                    if (object != null) {
                        ((MagnifierView)((Object)object)).eraseMagnifier();
                    }
                    this.invalidate();
                    return true;
                }
                case 0: {
                    a a2;
                    PointF pointF;
                    EditPolygonImageView editPolygonImageView = this;
                    int n2 = editPolygonImageView.handleSize >> 1;
                    float f4 = n2;
                    editPolygonImageView.touchRect.set(object.getX() - this.offsetX - f4, object.getY() - this.offsetY - f4, object.getX() - this.offsetX + f4, object.getY() - this.offsetY + f4);
                    for (PointF pointF2 : editPolygonImageView.corners) {
                        if (!this.touchRect.contains(pointF2.x, pointF2.y)) continue;
                        this.selectedCorner = pointF2;
                        this.invalidate();
                        return true;
                    }
                    Iterator<Object> iterator = this.edges.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        a2 = (a)iterator.next();
                        pointF = a2.b();
                    } while (!this.touchRect.contains(pointF.x, pointF.y));
                    EditPolygonImageView editPolygonImageView2 = this;
                    a a3 = this.selectedEdge = a2;
                    a.a(a2, object.getX());
                    a.b(a3, object.getY());
                    a3.f.a(a2.a, a2.c);
                    a3.g.a(a2.b, a2.d);
                    editPolygonImageView2.finger.set(pointF);
                    editPolygonImageView2.invalidate();
                    return true;
                }
            }
            for (int i3 = 0; i3 < this.horizontalLines.size(); ++i3) {
                double d5;
                double d6 = this.horizontalLines.get(i3).a(this.finger);
                if (d5 < d2) {
                    line2D = this.horizontalLines2D.get(i3);
                } else {
                    d6 = d2;
                }
                d2 = d6;
            }
        }
        if (line2D != null && d2 < (double)this.magneticLineTreshold) {
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.selectedEdge.a.set(line2D.getStart());
            editPolygonImageView.selectedEdge.b.set(line2D.getEnd());
            a.a(editPolygonImageView.selectedEdge, true);
        } else {
            EditPolygonImageView editPolygonImageView = this;
            a.a(editPolygonImageView.selectedEdge, false);
            PointF pointF = editPolygonImageView.selectedEdge.b();
            PointF pointF3 = editPolygonImageView.finger;
            f2 = pointF3.x - pointF.x;
            float f5 = pointF3.y - pointF.y;
            editPolygonImageView.selectedEdge.a.offset(f2, f5);
            editPolygonImageView.selectedEdge.b.offset(f2, f5);
        }
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.selectedEdge.e.a(this.selectedEdge.a, this.selectedEdge.b);
        PointF pointF = editPolygonImageView.selectedEdge.e.a(this.selectedEdge.f);
        if (!Float.isNaN(pointF.x) && !Float.isNaN(pointF.y)) {
            EditPolygonImageView editPolygonImageView3 = this;
            editPolygonImageView3.selectedEdge.a.set(pointF);
            pointF = editPolygonImageView3.selectedEdge.e.a(this.selectedEdge.g);
            if (!Float.isNaN(pointF.x) && !Float.isNaN(pointF.y)) {
                EditPolygonImageView editPolygonImageView4 = this;
                editPolygonImageView4.selectedEdge.b.set(pointF);
                editPolygonImageView4.keepInsideView(editPolygonImageView4.selectedEdge.a);
                editPolygonImageView4.keepInsideView(editPolygonImageView4.selectedEdge.b);
                a.a(editPolygonImageView4.selectedEdge, object.getX());
                a.b(editPolygonImageView4.selectedEdge, object.getY());
                editPolygonImageView4.invalidate();
                return true;
            }
            this.restoreSelectedEdge();
            return false;
        }
        this.restoreSelectedEdge();
        return false;
    }

    void setMagnifier(MagnifierView magnifierView) {
        this.magnifierView = magnifierView;
        this.invalidate();
    }

    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }

    private class b {
        private double a;
        private double b;
        private double c;
        private PointF d = new PointF();

        private b() {
        }

        /* synthetic */ b(net.doo.snap.ui.a a2) {
            this();
        }

        PointF a(b b2) {
            PointF pointF = this.d;
            b b3 = this;
            double d2 = b3.c;
            double d3 = b2.b;
            double d4 = d2 * d3;
            double d5 = b3.b;
            double d6 = b2.c;
            double d7 = b2.a;
            double d8 = d5 * d7;
            double d9 = b3.a;
            pointF.x = (float)((d4 -= d5 * d6) / (d8 - d9 * d3));
            pointF.y = (float)((d9 * d6 - d2 * d7) / (d5 * d7 - d9 * d3));
            return pointF;
        }

        void a(PointF pointF, PointF pointF2) {
            float f2 = pointF.y;
            float f3 = pointF2.y;
            this.a = f2 - f3;
            float f4 = pointF2.x;
            float f5 = pointF.x;
            this.b = f4 - f5;
            this.c = (f5 - f4) * f2 + (f3 - f2) * f5;
        }

        double a(PointF pointF) {
            if (this.a == 0.0 && this.b == 0.0) {
                return 0.0;
            }
            double d2 = this.a;
            double d3 = this.b;
            return Math.abs(this.a * (double)pointF.x + this.b * (double)pointF.y + this.c) / Math.sqrt(d2 * d2 + d3 * d3);
        }
    }

    private class a {
        private PointF a;
        private PointF b;
        private PointF c;
        private PointF d;
        private b e;
        private b f;
        private b g;
        private PointF h;
        private float i;
        private float j;
        private boolean k;

        private a() {
            this.e = new b(null);
            this.f = new b(null);
            this.g = new b(null);
            this.h = new PointF();
            this.k = false;
        }

        /* synthetic */ a(net.doo.snap.ui.a a2) {
            this();
        }

        static /* synthetic */ PointF a(a a2, PointF pointF) {
            a2.a = pointF;
            return pointF;
        }

        static /* synthetic */ PointF b(a a2, PointF pointF) {
            a2.b = pointF;
            return pointF;
        }

        static /* synthetic */ PointF c(a a2, PointF pointF) {
            a2.c = pointF;
            return pointF;
        }

        static /* synthetic */ PointF d(a a2, PointF pointF) {
            a2.d = pointF;
            return pointF;
        }

        static /* synthetic */ float a(a a2, float f2) {
            a2.i = f2;
            return f2;
        }

        static /* synthetic */ float b(a a2, float f2) {
            a2.j = f2;
            return f2;
        }

        static /* synthetic */ boolean a(a a2, boolean bl) {
            a2.k = bl;
            return bl;
        }

        float a() {
            PointF pointF = a2.b;
            a a2 = a2.a;
            float f2 = pointF.x - ((PointF)a2).x;
            return (float)(Math.toDegrees(Math.atan2(pointF.y - ((PointF)a2).y, f2)) + 90.0);
        }

        PointF b() {
            PointF pointF = a2.a;
            a a2 = a2.b;
            a2.h.x = (pointF.x + ((PointF)a2).x) / 2.0f;
            a2.h.y = (pointF.y + ((PointF)a2).y) / 2.0f;
            return a2.h;
        }

        boolean c() {
            PointF pointF = a2.b;
            a a2 = a2.a;
            float f2 = pointF.y - ((PointF)a2).y;
            return Math.abs(pointF.x - ((PointF)a2).x) > Math.abs(f2);
        }
    }
}

