/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.doo.snap.entity.Page;
import net.doo.snap.entity.e;

public class SnappingDraft
implements Parcelable {
    public static final Parcelable.Creator<SnappingDraft> CREATOR = new e();
    private final ArrayList<Page> pages;
    private String documentName;
    private boolean isCombined;

    public SnappingDraft(Page ... pageArray) {
        SnappingDraft snappingDraft = this;
        snappingDraft.isCombined = true;
        snappingDraft.pages = new ArrayList();
        Collections.addAll(snappingDraft.pages, pageArray);
    }

    protected SnappingDraft(Parcel parcel) {
        this.isCombined = true;
        if (parcel.readByte() == 1) {
            this.pages = new ArrayList();
            parcel.readList(this.pages, Page.class.getClassLoader());
        } else {
            this.pages = null;
        }
        this.documentName = parcel.readString();
        boolean bl = parcel.readByte() != 0;
        this.isCombined = bl;
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public void addPage(int n2, Page page) {
        this.pages.add(n2, page);
    }

    public void replacePage(int n2, Page page) throws a {
        if (this.pages.size() != 0 && n2 >= 0 && n2 < this.pages.size()) {
            SnappingDraft snappingDraft = this;
            snappingDraft.pages.remove(n2);
            if (n2 == snappingDraft.pages.size()) {
                this.pages.add(page);
            } else {
                this.pages.add(n2, page);
            }
            return;
        }
        throw new a();
    }

    public Page getPage(int n2) throws a {
        if (this.pages.size() != 0 && n2 >= 0 && n2 < this.pages.size()) {
            return this.pages.get(n2);
        }
        throw new a();
    }

    public void deletePage(int n2) throws a {
        if (this.pages.size() != 0 && n2 >= 0 && n2 < this.pages.size()) {
            this.pages.remove(n2);
            return;
        }
        throw new a();
    }

    public void deletePage(Page page) {
        this.pages.remove(page);
    }

    public int getPosition(Page page) {
        return this.pages.indexOf(page);
    }

    public int size() {
        return this.pages.size();
    }

    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    public List<Page> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String string) {
        this.documentName = string;
    }

    public boolean isCombined() {
        return this.isCombined;
    }

    public void setCombined(boolean bl) {
        this.isCombined = bl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        if (this.pages == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeList(this.pages);
        }
        parcel.writeString(this.documentName);
        parcel.writeByte((byte)(this.isCombined ? 1 : 0));
    }

    public static class a
    extends IndexOutOfBoundsException {
    }
}

