/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence.cleanup;

import android.util.Pair;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import java.util.Iterator;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.h;
import net.doo.snap.process.util.DocumentDraft;

public class Cleaner {
    private final UnreferencedSourcesProvider a;
    private final PageStoreStrategy b;
    private final DocumentStoreStrategy c;
    private final h d;
    private final PageStorageProcessor e;

    @Inject
    public Cleaner(UnreferencedSourcesProvider unreferencedSourcesProvider, PageStoreStrategy pageStoreStrategy, DocumentStoreStrategy documentStoreStrategy, h h2, PageStorageProcessor pageStorageProcessor) {
        this.a = unreferencedSourcesProvider;
        this.b = pageStoreStrategy;
        this.c = documentStoreStrategy;
        this.d = h2;
        this.e = pageStorageProcessor;
    }

    public void cleanUp() {
        for (Pair<String, String> object : this.a.getUnreferencedDocuments()) {
            this.c.eraseDocument((String)object.first, (String)object.second);
        }
        for (String string : this.a.getUnreferencedSDKPages()) {
            this.b.erasePage(string);
        }
        Iterator<Object> iterator = this.d.b().iterator();
        while (iterator.hasNext()) {
            this.cleanUpPagesData(((DocumentDraft)iterator.next()).getPages());
        }
    }

    public void cleanUpPagesData(net.doo.snap.entity.Page[] pageArray) {
        for (net.doo.snap.entity.Page page : pageArray) {
            this.b.eraseTempPageData(page.getId());
        }
    }

    public void cleanUpPagesData(Page[] pageArray) {
        for (Page page : pageArray) {
            this.e.erasePageData(page);
        }
    }

    public void cleanUpDocumentData(Document document) {
        this.c.eraseDocument(document.getId(), document.getName());
    }

    public void cleanUpDocumentThumbnail(Document document) {
        this.c.eraseDocumentThumbnail(document.getId());
    }
}

