/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.pdf;

import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.Locale;
import net.doo.snap.util.pdf.a;

public class PdfUtils {
    public static final float UNIT_SIZE_INCHES = 0.013888889f;
    public static final float A4_HEIGHT_INCHES = 11.692f;
    public static final float A4_WIDTH_INCHES = 8.27f;
    public static final float A4_HEIGHT_UNITS = 841.82404f;
    public static final float A4_WIDTH_UNITS = 595.44f;
    public static final float US_LETTER_HEIGHT_INCHES = 10.98f;
    public static final float US_LETTER_WIDTH_INCHES = 8.5f;
    public static final float US_LETTER_HEIGHT_UNITS = 790.55994f;
    public static final float US_LETTER_WIDTH_UNITS = 612.0f;

    public static RectF defaultPhysicalBounds() {
        return new RectF(0.0f, 0.0f, 11.692f, 11.692f);
    }

    public static RectF a4PhysicalBounds(RectF rectF) {
        if (rectF.width() <= rectF.height()) {
            return new RectF(0.0f, 0.0f, 8.27f, 11.692f);
        }
        return new RectF(0.0f, 0.0f, 11.692f, 8.27f);
    }

    public static RectF usLetterPhysicalBounds(RectF rectF) {
        if (rectF.width() <= rectF.height()) {
            return new RectF(0.0f, 0.0f, 8.5f, 10.98f);
        }
        return new RectF(0.0f, 0.0f, 10.98f, 8.5f);
    }

    public static RectF fitToPhysicalBounds(RectF rectF, RectF rectF2) {
        float f2 = Math.min(rectF2.width() / (rectF.width() * 0.013888889f), rectF2.height() / (rectF.height() * 0.013888889f));
        RectF rectF3 = rectF;
        float f3 = rectF3.width() * f2;
        f2 = rectF3.height() * f2;
        return new RectF(0.0f, 0.0f, f3, f2);
    }

    @NonNull
    public static RectF calculatePageBounds(PDFPageSize pDFPageSize, Rect rect, int n2) {
        RectF rectF;
        int n3;
        Locale locale = Locale.getDefault();
        if (n2 != 90 && n2 != 270) {
            Rect rect2 = rect;
            n3 = rect2.width();
            n2 = rect2.height();
        } else {
            Rect rect3 = rect;
            n3 = rect3.height();
            n2 = rect3.width();
        }
        RectF rectF2 = rectF;
        float f2 = n3;
        float f3 = n2;
        rectF = new RectF(0.0f, 0.0f, f2, f3);
        switch (a.a[pDFPageSize.ordinal()]) {
            default: {
                return rectF2;
            }
            case 7: {
                return new RectF(0.0f, 0.0f, f2, f3);
            }
            case 6: {
                float f4 = f2 / f3;
                float f5 = n3 <= n2 ? 0.7073212f : 1.4137849f;
                float f6 = n3 <= n2 ? 0.7741349f : 1.2917646f;
                if (Math.abs(f4 - f5) <= Math.abs(f4 - f6)) {
                    return PdfUtils.calculateA4PageBounds(rectF2);
                }
                return PdfUtils.calculateUSLetterPageBounds(rectF2);
            }
            case 5: {
                if (locale == Locale.US) {
                    return PdfUtils.calculateUSLetterPageBounds(rectF2);
                }
                return PdfUtils.calculateA4PageBounds(rectF2);
            }
            case 4: {
                return PdfUtils.calculateFixedUSLetterPageBounds(n3, n2);
            }
            case 3: {
                return PdfUtils.calculateUSLetterPageBounds(rectF2);
            }
            case 2: {
                return PdfUtils.calculateFixedA4PageBounds(n3, n2);
            }
            case 1: 
        }
        return PdfUtils.calculateA4PageBounds(rectF2);
    }

    @NonNull
    private static RectF calculateFixedUSLetterPageBounds(int n2, int n3) {
        float f2 = n2 <= n3 ? 612.0f : 790.55994f;
        float f3 = n2 <= n3 ? 790.55994f : 612.0f;
        return new RectF(0.0f, 0.0f, f2, f3);
    }

    @NonNull
    private static RectF calculateFixedA4PageBounds(int n2, int n3) {
        float f2 = n2 <= n3 ? 595.44f : 841.82404f;
        float f3 = n2 <= n3 ? 841.82404f : 595.44f;
        return new RectF(0.0f, 0.0f, f2, f3);
    }

    @NonNull
    private static RectF calculateUSLetterPageBounds(RectF rectF) {
        RectF rectF2 = rectF;
        return PdfUtils.fitToPhysicalBounds(rectF2, PdfUtils.usLetterPhysicalBounds(rectF2));
    }

    @NonNull
    private static RectF calculateA4PageBounds(RectF rectF) {
        RectF rectF2 = rectF;
        return PdfUtils.fitToPhysicalBounds(rectF2, PdfUtils.a4PhysicalBounds(rectF2));
    }
}

