/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.d.a;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.R;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    protected final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    protected boolean enabled = true;
    private List<PageAspectRatio> requiredPageAspectRatios = null;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        cameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        return contourDetectorFrameHandler;
    }

    public ContourDetectorFrameHandler(Context context) {
        this.contourDetector = new ContourDetector();
        this.sapManager = c.a();
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
    }

    @Override
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        this.fixRequiredAspectRatios(previewFrame.frameOrientation);
        this.setRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
        DetectionResult detectionResult = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
        List list = this.contourDetector.getPolygonF();
        detectionResult = this.detectOffCenter(previewFrame, detectionResult, list);
        DetectedFrame detectedFrame = new DetectedFrame(detectionResult, list, previewFrame.frameOrientation, previewFrame.width, previewFrame.height, this.contourDetector.getDetectionScore(), previewFrame.finderRect, this.requiredPageAspectRatios);
        return this.notifyHandlers(detectedFrame);
    }

    private DetectionResult detectOffCenter(PreviewBuffer.FrameHandler.Frame previewFrame, DetectionResult detectionResult, List<PointF> polygon) {
        if (!(previewFrame.finderRect == null || previewFrame.finderRect.isEmpty() || detectionResult != DetectionResult.OK && detectionResult != DetectionResult.OK_BUT_BAD_ASPECT_RATIO && detectionResult != DetectionResult.OK_BUT_TOO_SMALL && detectionResult != DetectionResult.OK_BUT_BAD_ANGLES)) {
            int n2;
            List<PointF> list = a.a(polygon, previewFrame.frameOrientation);
            boolean bl = previewFrame.frameOrientation % 180 == 0;
            int n3 = bl ? previewFrame.width : previewFrame.height;
            Rect rect = new Rect((int)(list.get((int)0).x * (float)n3), (int)(list.get((int)0).y * (float)(n2 = bl ? previewFrame.height : previewFrame.width)), (int)(list.get((int)2).x * (float)n3), (int)(list.get((int)2).y * (float)n2));
            if (this.checkOuterThreshold(previewFrame.finderRect, rect)) {
                detectionResult = DetectionResult.OK_OFF_CENTER;
            } else if (!this.requiredPageAspectRatios.isEmpty() && this.checkInnerThreshold(previewFrame.finderRect, rect)) {
                detectionResult = DetectionResult.OK_BUT_TOO_SMALL;
            }
        }
        return detectionResult;
    }

    private boolean checkInnerThreshold(Rect finderRect, Rect polygonRect) {
        return polygonRect.left - finderRect.left > this.finderInnerThresholdPx || polygonRect.top - finderRect.top > this.finderInnerThresholdPx || finderRect.bottom - polygonRect.bottom > this.finderInnerThresholdPx || finderRect.right - polygonRect.right > this.finderInnerThresholdPx;
    }

    private boolean checkOuterThreshold(Rect finderRect, Rect polygonRect) {
        return finderRect.left - polygonRect.left > this.finderOuterThresholdPx || finderRect.top - polygonRect.top > this.finderOuterThresholdPx || polygonRect.bottom - finderRect.bottom > this.finderOuterThresholdPx || polygonRect.right - finderRect.right > this.finderOuterThresholdPx;
    }

    private void setRectOfInterest(int frameOrientation, RectF visibleRect) {
        if (visibleRect != null) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)frameOrientation, 0.5f, 0.5f);
            matrix.mapRect(visibleRect);
            this.contourDetector.setRectOfInterest(visibleRect);
        }
    }

    private void fixRequiredAspectRatios(int frameOrientation) {
        if (this.requiredPageAspectRatios != null && !this.requiredPageAspectRatios.isEmpty()) {
            ArrayList<PageAspectRatio> arrayList = new ArrayList<PageAspectRatio>();
            for (PageAspectRatio pageAspectRatio : this.requiredPageAspectRatios) {
                boolean bl = frameOrientation % 180 == 0;
                PageAspectRatio pageAspectRatio2 = bl ? new PageAspectRatio(pageAspectRatio.width, pageAspectRatio.height) : new PageAspectRatio(pageAspectRatio.height, pageAspectRatio.width);
                arrayList.add(pageAspectRatio2);
            }
            this.contourDetector.setRequiredAspectRatios(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        if (acceptedAngleScore < 0.0 || acceptedAngleScore > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
        }
        this.contourDetector.setAcceptedAngleScore(acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        if (acceptedSizeScore < 0.0 || acceptedSizeScore > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
        }
        this.contourDetector.setAcceptedSizeScore(acceptedSizeScore);
    }

    public final void setRequiredAspectRatios(List<PageAspectRatio> requiredPageAspectRatios) {
        this.requiredPageAspectRatios = requiredPageAspectRatios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyHandlers(DetectedFrame detectedFrame) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(detectedFrame);
            }
        }
        return bl;
    }

    public static class DetectedFrame {
        public static final int NO_ERROR = -1;
        public static final int ERROR_LICENSE_INVALID = 1;
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;
        public final int errorCode;
        public final Rect finderRect;
        public final List<PageAspectRatio> requiredPageAspectRatios;

        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = 0.0;
            this.errorCode = -1;
            this.finderRect = null;
            this.requiredPageAspectRatios = null;
        }

        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, Rect finderRect, List<PageAspectRatio> requiredPageAspectRatios) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = detectionScore;
            this.errorCode = -1;
            this.finderRect = finderRect;
            this.requiredPageAspectRatios = requiredPageAspectRatios;
        }

        public DetectedFrame(int errorCode) {
            this.detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
            this.frameOrientation = 0;
            this.frameWidth = 0;
            this.frameHeight = 0;
            this.polygon = Collections.emptyList();
            this.detectionScore = 0.0;
            this.errorCode = errorCode;
            this.finderRect = null;
            this.requiredPageAspectRatios = null;
        }
    }

    public static interface ResultHandler {
        public boolean handleResult(DetectedFrame var1);
    }
}

