/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.businesscard;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.scanbot.sdk.businesscard.BusinessCardsImageProcessor;
import io.scanbot.sdk.businesscard.DefaultBusinessCardsImageProcessor$WhenMappings;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.PageProcessor;
import io.scanbot.sdk.textorientation.TextOrientationScanner;
import io.scanbot.textorientation.model.TextOrientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.entity.Language;
import net.doo.snap.process.OcrResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/businesscard/DefaultBusinessCardsImageProcessor;", "Lio/scanbot/sdk/businesscard/BusinessCardsImageProcessor;", "opticalCharacterRecognizer", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageProcessor", "Lio/scanbot/sdk/process/PageProcessor;", "textOrientationScanner", "Lio/scanbot/sdk/textorientation/TextOrientationScanner;", "(Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/process/PageProcessor;Lio/scanbot/sdk/textorientation/TextOrientationScanner;)V", "normalizePageOrientation", "Lio/scanbot/sdk/persistence/Page;", "it", "processPages", "", "Lio/scanbot/sdk/businesscard/BusinessCardsImageProcessor$BusinessCardProcessingResult;", "pages", "ocrLanguages", "", "Lnet/doo/snap/entity/Language;", "performOCR", "", "performAutoRotation", "scanbot-sdk_release"})
public final class DefaultBusinessCardsImageProcessor
implements BusinessCardsImageProcessor {
    private final OpticalCharacterRecognizer opticalCharacterRecognizer;
    private final PageFileStorage pageFileStorage;
    private final PageProcessor pageProcessor;
    private final TextOrientationScanner textOrientationScanner;

    @Override
    @NotNull
    public List<BusinessCardsImageProcessor.BusinessCardProcessingResult> processPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> ocrLanguages, boolean performOCR, boolean performAutoRotation) {
        Object object;
        boolean bl;
        Collection collection;
        Page page;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(ocrLanguages, (String)"ocrLanguages");
        Iterable iterable = pages;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        for (Object t2 : iterable2) {
            page = (Page)t2;
            collection = collection2;
            bl = false;
            object = performAutoRotation ? this.normalizePageOrientation(page) : page;
            collection.add(object);
        }
        iterable = (List)collection2;
        bl2 = false;
        iterable2 = iterable;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t2 : iterable2) {
            page = (Page)t2;
            collection = collection2;
            bl = false;
            Page page2 = this.pageProcessor.applyFilter(page, ImageFilterType.OTSU_BINARIZATION);
            OcrResult ocrResult = performOCR ? this.opticalCharacterRecognizer.recognizeTextFromPages(CollectionsKt.listOf((Object)page2), ocrLanguages) : null;
            object = new BusinessCardsImageProcessor.BusinessCardProcessingResult(page, ocrResult);
            collection.add(object);
        }
        return (List)collection2;
    }

    private final Page normalizePageOrientation(Page it) {
        Page page;
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeFile((String)this.pageFileStorage.getImageURI(it.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        TextOrientation textOrientation = this.textOrientationScanner.recognizeBitmap(bitmap2, 0.0f);
        switch (DefaultBusinessCardsImageProcessor$WhenMappings.$EnumSwitchMapping$0[textOrientation.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                page = it;
                break;
            }
            case 4: {
                page = this.pageProcessor.rotate(it, 1);
                break;
            }
            case 5: {
                page = this.pageProcessor.rotate(it, 2);
                break;
            }
            case 6: {
                page = this.pageProcessor.rotate(it, 3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return page;
    }

    @Inject
    public DefaultBusinessCardsImageProcessor(@NotNull OpticalCharacterRecognizer opticalCharacterRecognizer, @NotNull PageFileStorage pageFileStorage, @NotNull PageProcessor pageProcessor, @NotNull TextOrientationScanner textOrientationScanner) {
        Intrinsics.checkParameterIsNotNull((Object)opticalCharacterRecognizer, (String)"opticalCharacterRecognizer");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageProcessor, (String)"pageProcessor");
        Intrinsics.checkParameterIsNotNull((Object)textOrientationScanner, (String)"textOrientationScanner");
        this.opticalCharacterRecognizer = opticalCharacterRecognizer;
        this.pageFileStorage = pageFileStorage;
        this.pageProcessor = pageProcessor;
        this.textOrientationScanner = textOrientationScanner;
    }
}

