/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> polygon) {
        return !polygon.isEmpty() && Math.abs(polygon.get((int)1).x - polygon.get((int)0).x) > 35 && Math.abs(polygon.get((int)2).x - polygon.get((int)3).x) > 35 && Math.abs(polygon.get((int)3).y - polygon.get((int)0).y) > 35 && Math.abs(polygon.get((int)2).y - polygon.get((int)1).y) > 35;
    }

    public void setRotation(int degrees) {
        if (this.rotation == degrees) {
            return;
        }
        this.rotation = degrees;
        this.matrix.setRotate((float)degrees, 0.5f, 0.5f);
    }

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLayout(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void polygonToPoints(List<PointF> polygon, float[] points) {
        int n2;
        for (n2 = 0; n2 < polygon.size(); ++n2) {
            this.tmpPoints[n2 * 2] = polygon.get((int)n2).x;
            this.tmpPoints[n2 * 2 + 1] = polygon.get((int)n2).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n2 = 0; n2 < polygon.size(); ++n2) {
            points[n2 * 4] = (float)this.left + (float)this.width * this.tmpPoints[n2 * 2];
            points[n2 * 4 + 1] = (float)this.top + (float)this.height * this.tmpPoints[n2 * 2 + 1];
            points[n2 * 4 + 2] = (float)this.left + (float)this.width * this.tmpPoints[(n2 * 2 + 2) % 8];
            points[n2 * 4 + 3] = (float)this.top + (float)this.height * this.tmpPoints[(n2 * 2 + 3) % 8];
        }
    }

    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        for (int i2 = 0; i2 < drawingPolygon.size(); ++i2) {
            PointF pointF = polygon.get(i2);
            PointF pointF2 = drawingPolygon.get(i2);
            pointF2.x = pointF.x * (float)this.width;
            pointF2.y = pointF.y * (float)this.height;
        }
    }

    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        for (int i2 = 0; i2 < drawingPolygon.size(); ++i2) {
            PointF pointF = polygon.get(i2);
            PointF pointF2 = drawingPolygon.get(i2);
            pointF.x = pointF2.x / (float)this.width;
            pointF.y = pointF2.y / (float)this.height;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> lines) {
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (Line2D line2D : lines) {
            line2D.getStart().x = (float)this.left + (float)this.width * line2D.getStart().x;
            line2D.getStart().y = (float)this.top + (float)this.height * line2D.getStart().y;
            line2D.getEnd().x = (float)this.left + (float)this.width * line2D.getEnd().x;
            line2D.getEnd().y = (float)this.top + (float)this.height * line2D.getEnd().y;
            arrayList.add(line2D);
        }
        return arrayList;
    }

    public static class Line {
        private double a;
        private double b;
        private double c;
        private PointF intersectionPoint = new PointF();

        public PointF getIntersectionPoint(Line line) {
            this.intersectionPoint.x = (float)((this.c * line.b - this.b * line.c) / (this.b * line.a - this.a * line.b));
            this.intersectionPoint.y = (float)((this.a * line.c - this.c * line.a) / (this.b * line.a - this.a * line.b));
            return this.intersectionPoint;
        }

        public void calculateLine(PointF start, PointF end) {
            this.a = start.y - end.y;
            this.b = end.x - start.x;
            this.c = (start.x - end.x) * start.y + (end.y - start.y) * start.x;
        }

        public double getDistanceToPoint(PointF point) {
            if (this.a != 0.0 || this.b != 0.0) {
                return Math.abs(this.a * (double)point.x + this.b * (double)point.y + this.c) / Math.sqrt(this.a * this.a + this.b * this.b);
            }
            return 0.0;
        }
    }

    public static class Edge {
        public PointF pointA;
        public PointF pointB;
        public PointF pointFarA;
        public PointF pointFarB;
        public Line edgeLine = new Line();
        public Line lineA = new Line();
        public Line lineB = new Line();
        private PointF handle = new PointF();
        public float prevX;
        public float prevY;
        public boolean isDetectedLine = false;

        public float getAngleInDegrees() {
            float f2 = this.pointB.y - this.pointA.y;
            float f3 = this.pointB.x - this.pointA.x;
            double d2 = Math.atan2(f2, f3);
            d2 = Math.toDegrees(d2);
            return (float)(d2 += 90.0);
        }

        public PointF getHandle() {
            this.handle.x = (this.pointA.x + this.pointB.x) / 2.0f;
            this.handle.y = (this.pointA.y + this.pointB.y) / 2.0f;
            return this.handle;
        }

        public boolean isHorizontal() {
            float f2 = this.pointB.y - this.pointA.y;
            float f3 = this.pointB.x - this.pointA.x;
            return Math.abs(f3) > Math.abs(f2);
        }
    }
}

