/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.c.c;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private static final int TAKE_PICTURE_DELAY_MS = 500;
    private CameraView cameraView;
    private net.doo.snap.camera.a cameraHost;
    private boolean resumed = false;
    private b state = b.a;
    private final Set<CameraStateCallback> stateCallbacks = new LinkedHashSet<CameraStateCallback>();
    private final Set<CameraTakePictureCallback> takePictureCallbacks = new LinkedHashSet<CameraTakePictureCallback>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        this.cameraView = new CameraView(context);
        this.cameraHost = new net.doo.snap.camera.a(context);
        this.cameraView.setCameraHost((CameraHost)this.cameraHost);
        this.cameraView.a(new a());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        this.addView((View)this.cameraView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.logger.logMethod();
        super.onLayout(changed, left, top, right, bottom);
        View view = this.cameraView.getChildAt(0);
        if (view == null) {
            return;
        }
        int n2 = this.getChildCount();
        int n3 = View.MeasureSpec.makeMeasureSpec((int)view.getWidth(), (int)Integer.MIN_VALUE);
        int n4 = View.MeasureSpec.makeMeasureSpec((int)view.getHeight(), (int)Integer.MIN_VALUE);
        for (int i2 = 1; i2 < n2; ++i2) {
            View view2 = this.getChildAt(i2);
            if (view2 instanceof CameraView) continue;
            view2.measure(n3, n4);
            view2.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.b();
    }

    public void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = c.a().isLicenseActive();
        this.state = b.a;
        this.cameraView.onResume();
        this.notifyResumedState();
    }

    public void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state = b.a;
        this.cameraView.onPause();
        this.notifyPausedState();
    }

    private void notifyResumedState() {
        for (CameraStateCallback cameraStateCallback : this.stateCallbacks) {
            cameraStateCallback.onResume();
        }
    }

    private void notifyPausedState() {
        for (CameraStateCallback cameraStateCallback : this.stateCallbacks) {
            cameraStateCallback.onPause();
        }
    }

    private void notifyTakePictureCancelled() {
        for (CameraTakePictureCallback cameraTakePictureCallback : this.takePictureCallbacks) {
            cameraTakePictureCallback.onTakePictureCancelled();
        }
    }

    public void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.stopPreview();
    }

    public void takePicture(boolean aquireFocus) {
        this.logger.logMethod();
        if (this.state != b.a) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
            if (!this.resumed) {
                return;
            }
        }
        if (aquireFocus) {
            this.state = b.b;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    private void performSnapping() {
        this.state = b.c;
        try {
            Camera.Parameters parameters = this.cameraView.getCameraParameters();
            PictureTransaction pictureTransaction = new PictureTransaction((CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (parameters != null) {
                pictureTransaction = pictureTransaction.flashMode(parameters.getFlashMode());
            }
            this.cameraView.takePicture(pictureTransaction);
        }
        catch (IllegalStateException illegalStateException) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
        }
    }

    public void useFlash(boolean useFlash) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (Utils.isFlashSupported(parameters)) {
            this.cameraView.setFlashMode(useFlash ? "torch" : "off");
        }
    }

    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.cameraView.a(autoFocusOnTouch);
    }

    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.a();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.a(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.b(pictureCallback);
    }

    void addCameraStateCallback(CameraStateCallback cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.add(cameraStateCallback);
    }

    void removeCameraStateCallback(CameraStateCallback cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.remove(cameraStateCallback);
    }

    void addTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.add(cameraTakePictureCallback);
    }

    void removeTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.remove(cameraTakePictureCallback);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraView.a(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size pictureSize) {
        this.logger.logMethod();
        this.cameraHost.a(pictureSize);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPictureSize(pictureSize.width, pictureSize.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setPreviewSize(Camera.Size previewSize) {
        this.logger.logMethod();
        this.cameraHost.b(previewSize);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPreviewSize(previewSize.width, previewSize.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setAutoFocusSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.a(enabled);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.b(enabled);
        this.cameraView.b(enabled);
    }

    public void setPreviewMode(CameraPreviewMode mode) {
        this.logger.logMethod();
        this.cameraHost.a(mode);
    }

    @Deprecated
    public void lockToPortrait() {
        this.logger.logMethod();
        this.cameraView.lockToPortrait();
    }

    @Deprecated
    public void lockToLandscape() {
        this.logger.logMethod();
        this.cameraView.lockToLandscape();
    }

    public void lockToPortrait(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToPortrait(lockPicture);
    }

    public void lockToLandscape(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToLandscape(lockPicture);
    }

    public void unlockOrientation() {
        this.logger.logMethod();
        this.cameraView.unlockOrientation();
    }

    private static enum b {
        a,
        b,
        c;

    }

    private class a
    implements CameraView.AutofocusCallback {
        private a() {
        }

        @Override
        public void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            ScanbotCameraView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ScanbotCameraView.this.state == b.b) {
                        ScanbotCameraView.this.performSnapping();
                    } else {
                        ScanbotCameraView.this.state = b.a;
                        ScanbotCameraView.this.notifyTakePictureCancelled();
                    }
                }
            }, 500L);
        }
    }
}

