/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class MRZScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private MRZScanner mrzScanner;
    private final Set<ResultHandler> handlers;
    protected final SapManager sapManager;
    private final Logger logger;
    protected boolean enabled;

    /*
     * WARNING - void declaration
     */
    public static MRZScannerFrameHandler attach(ScanbotCameraView cameraView, MRZScanner mrzScanner) {
        void var1_1;
        ScanbotCameraView scanbotCameraView;
        MRZScannerFrameHandler mRZScannerFrameHandler;
        MRZScannerFrameHandler mRZScannerFrameHandler2 = mRZScannerFrameHandler;
        mRZScannerFrameHandler2(scanbotCameraView.getContext(), (MRZScanner)var1_1);
        scanbotCameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)mRZScannerFrameHandler2);
        return mRZScannerFrameHandler;
    }

    /*
     * WARNING - void declaration
     */
    public MRZScannerFrameHandler(Context context, MRZScanner mrzScanner) {
        void var2_2;
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        mRZScannerFrameHandler.mrzScanner = var2_2;
        mRZScannerFrameHandler.sapManager = SapSingleton.getInstance();
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        Object object;
        MRZScannerFrameHandler mRZScannerFrameHandler = this_;
        mRZScannerFrameHandler.logger.logMethod();
        if (!mRZScannerFrameHandler.enabled) {
            return false;
        }
        if (!this_.sapManager.checkLicenseStatus(SdkFeature.MRZRecognition).booleanValue()) {
            SdkLicenseError sdkLicenseError;
            FrameHandlerResult.Failure failure;
            MRZScannerFrameHandler mRZScannerFrameHandler2 = this_;
            MRZScannerFrameHandler this_ = failure;
            object = sdkLicenseError;
            sdkLicenseError = new SdkLicenseError();
            failure = new FrameHandlerResult.Failure(object);
            mRZScannerFrameHandler2.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)this_);
            return false;
        }
        Rect rect = object.finderRect;
        if (rect == null) {
            SdkLicenseError sdkLicenseError = object;
            object = sdkLicenseError.frame;
            int n2 = sdkLicenseError.width;
            int n3 = sdkLicenseError.height;
            int n4 = sdkLicenseError.frameOrientation;
            object = this_.mrzScanner.recognizeMRZ((byte[])object, n2, n3, n4);
        } else {
            SdkLicenseError sdkLicenseError = object;
            object = sdkLicenseError.frame;
            int n5 = sdkLicenseError.width;
            int n6 = sdkLicenseError.height;
            int n7 = sdkLicenseError.frameOrientation;
            object = this_.mrzScanner.recognizeMRZWithFinderOverlay((byte[])object, n5, n6, n7, rect, false);
        }
        return this_.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)new FrameHandlerResult.Success(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.remove(var1_1);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this.enabled = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean notifyHandlers(FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> result) {
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = mRZScannerFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = mRZScannerFrameHandler.handlers.iterator();
            while (true) {
                void var1_2;
                if (!iterator.hasNext()) break;
                bl |= iterator.next().handle((FrameHandlerResult)var1_2);
                continue;
                break;
            }
            return bl;
        }
    }

    public static interface ResultHandler
    extends BaseResultHandler<MRZRecognitionResult, SdkLicenseError> {
    }
}

