/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.pdf;

import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.Locale;

public class PdfUtils {
    public static final float UNIT_SIZE_INCHES = 0.013888889f;
    public static final float A4_HEIGHT_INCHES = 11.692f;
    public static final float A4_WIDTH_INCHES = 8.27f;
    public static final float A4_HEIGHT_UNITS = 841.82404f;
    public static final float A4_WIDTH_UNITS = 595.44f;
    public static final float US_LETTER_HEIGHT_INCHES = 10.98f;
    public static final float US_LETTER_WIDTH_INCHES = 8.5f;
    public static final float US_LETTER_HEIGHT_UNITS = 790.55994f;
    public static final float US_LETTER_WIDTH_UNITS = 612.0f;

    public static RectF defaultPhysicalBounds() {
        return new RectF(0.0f, 0.0f, 11.692f, 11.692f);
    }

    public static RectF a4PhysicalBounds(RectF bounds) {
        if (bounds.width() <= bounds.height()) {
            return new RectF(0.0f, 0.0f, 8.27f, 11.692f);
        }
        return new RectF(0.0f, 0.0f, 11.692f, 8.27f);
    }

    public static RectF usLetterPhysicalBounds(RectF bounds) {
        if (bounds.width() <= bounds.height()) {
            return new RectF(0.0f, 0.0f, 8.5f, 10.98f);
        }
        return new RectF(0.0f, 0.0f, 10.98f, 8.5f);
    }

    public static RectF fitToPhysicalBounds(RectF bounds2, RectF physicalBounds2) {
        float physicalBounds2 = Math.min(physicalBounds2.width() / (bounds2.width() * 0.013888889f), physicalBounds2.height() / (bounds2.height() * 0.013888889f));
        RectF rectF = bounds2;
        float bounds2 = rectF.width() * physicalBounds2;
        physicalBounds2 = rectF.height() * physicalBounds2;
        return new RectF(0.0f, 0.0f, bounds2, physicalBounds2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static RectF calculatePageBounds(PDFPageSize pageSize, Rect bounds, int rotation) {
        PDFPageSize pDFPageSize;
        RectF rectF;
        int n2;
        void var1_2;
        int n3;
        Locale locale = Locale.getDefault();
        if (rotation != 90 && n3 != 270) {
            void v0 = var1_2;
            n2 = v0.width();
            n3 = v0.height();
        } else {
            void v1 = var1_2;
            n2 = v1.height();
            n3 = v1.width();
        }
        RectF rectF2 = rectF;
        float f2 = n2;
        float f3 = n3;
        rectF = new RectF(0.0f, 0.0f, f2, f3);
        switch (pDFPageSize) {
            default: {
                return rectF2;
            }
            case FROM_IMAGE: {
                return new RectF(0.0f, 0.0f, f2, f3);
            }
            case AUTO: {
                float f4 = f2 / f3;
                float f5 = n2 <= n3 ? 0.7073212f : 1.4137849f;
                float f6 = n2 <= n3 ? 0.7741349f : 1.2917646f;
                if (Math.abs(f4 - f5) <= Math.abs(f4 - f6)) {
                    return PdfUtils.calculateA4PageBounds(rectF2);
                }
                return PdfUtils.calculateUSLetterPageBounds(rectF2);
            }
            case AUTO_LOCALE: {
                if (locale == Locale.US) {
                    return PdfUtils.calculateUSLetterPageBounds(rectF2);
                }
                return PdfUtils.calculateA4PageBounds(rectF2);
            }
            case FIXED_US_LETTER: {
                return PdfUtils.calculateFixedUSLetterPageBounds(n2, n3);
            }
            case US_LETTER: {
                return PdfUtils.calculateUSLetterPageBounds(rectF2);
            }
            case FIXED_A4: {
                return PdfUtils.calculateFixedA4PageBounds(n2, n3);
            }
            case A4: 
        }
        return PdfUtils.calculateA4PageBounds(rectF2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private static RectF calculateFixedUSLetterPageBounds(int width, int height) {
        void var1_2;
        int n2;
        float f2 = width <= height ? 612.0f : 790.55994f;
        float f3 = n2 <= var1_2 ? 790.55994f : 612.0f;
        return new RectF(0.0f, 0.0f, f2, f3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private static RectF calculateFixedA4PageBounds(int width, int height) {
        void var1_2;
        int n2;
        float f2 = width <= height ? 595.44f : 841.82404f;
        float f3 = n2 <= var1_2 ? 841.82404f : 595.44f;
        return new RectF(0.0f, 0.0f, f2, f3);
    }

    @NonNull
    private static RectF calculateUSLetterPageBounds(RectF rotatedRect) {
        RectF rectF = rotatedRect;
        return PdfUtils.fitToPhysicalBounds(rectF, PdfUtils.usLetterPhysicalBounds(rectF));
    }

    @NonNull
    private static RectF calculateA4PageBounds(RectF rotatedRect) {
        RectF rectF = rotatedRect;
        return PdfUtils.fitToPhysicalBounds(rectF, PdfUtils.a4PhysicalBounds(rectF));
    }
}

