/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.R;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.ui.MagnifierView;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    public static final List<PointF> DEFAULT_POLYGON = new ArrayList<PointF>(){
        {
            a a2 = this;
            a2.add(new PointF(0.0f, 0.0f));
            a2.add(new PointF(1.0f, 0.0f));
            a2.add(new PointF(1.0f, 1.0f));
            a2.add(new PointF(0.0f, 1.0f));
        }
    };
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<PolygonHelper.Line> horizontalLines = new ArrayList<PolygonHelper.Line>();
    private final List<PolygonHelper.Line> verticalLines = new ArrayList<PolygonHelper.Line>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<PolygonHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private PolygonHelper.Edge selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue;
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix;
    private RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;

    public static List<PointF> getDefaultPolygon() {
        return new ArrayList<PointF>(){
            {
                b b2 = this;
                b2.add(new PointF(0.0f, 0.0f));
                b2.add(new PointF(1.0f, 0.0f));
                b2.add(new PointF(1.0f, 1.0f));
                b2.add(new PointF(0.0f, 1.0f));
            }
        };
    }

    public EditPolygonImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int n2;
        PolygonHelper.Edge edge;
        TypedArray typedArray;
        Comparator<PointF> comparator;
        Comparator<PointF> comparator2 = comparator;
        comparator = new Comparator<PointF>(){

            public int a(PointF lhs, PointF rhs) {
                return Double.compare(Math.atan2(lhs.y - EditPolygonImageView.this.medianY, lhs.x - EditPolygonImageView.this.medianX), Math.atan2(rhs.y - EditPolygonImageView.this.medianY, rhs.x - EditPolygonImageView.this.medianX));
            }
        };
        this.pointsQueue = new PriorityQueue<PointF>(4, comparator2);
        this.imageMatrix = new float[9];
        this.touchRect = new RectF();
        this.lastKnownImageWidth = -1;
        this.lastKnownImageHeight = -1;
        this.scaleLandscape = 1.0f;
        this.scalePortrait = 1.0f;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        EditPolygonImageView editPolygonImageView = this;
        typedArray = typedArray.getTheme().obtainStyledAttributes((AttributeSet)edge, R.styleable.EditPolygonImageView, 0, 0);
        try {
            this.edgeColor = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            this.edgeColorOnLine = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, this.edgeColor);
            this.cornerDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            this.edgeDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            this.magneticLineTreshold = typedArray.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            this.polygonStrokeWidth = typedArray.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.handleSize = typedArray.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
        editPolygonImageView.polygon = Collections.emptyList();
        editPolygonImageView.paint = new Paint();
        editPolygonImageView.paint.setColor(this.edgeColor);
        editPolygonImageView.paint.setStyle(Paint.Style.STROKE);
        editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paint.setAntiAlias(true);
        editPolygonImageView.paint.setStrokeCap(Paint.Cap.SQUARE);
        editPolygonImageView.paintOnLine = new Paint();
        editPolygonImageView.paintOnLine.setColor(this.edgeColorOnLine);
        editPolygonImageView.paintOnLine.setStyle(Paint.Style.STROKE);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paintOnLine.setAntiAlias(true);
        editPolygonImageView.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
        editPolygonImageView.handlePaint = new Paint();
        editPolygonImageView.handlePaint.setAntiAlias(true);
        editPolygonImageView.handlePaint.setFilterBitmap(true);
        editPolygonImageView.polygonHelper = new PolygonHelper();
        editPolygonImageView.corners = new ArrayList<PointF>();
        for (n2 = 0; n2 < 4; ++n2) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<PolygonHelper.Edge>();
        n2 = 0;
        while (n2 < this.corners.size()) {
            PolygonHelper.Edge edge2;
            edge = edge2;
            edge();
            edge.pointA = this.corners.get(n2);
            int n3 = n2 + 1;
            edge.pointB = this.corners.get(n3 % 4);
            edge.pointFarA = this.corners.get((n2 + 3) % 4);
            edge2.pointFarB = this.corners.get((n2 + 2) % 4);
            this.edges.add(edge);
            n2 = n3;
        }
        return;
    }

    private float getRotationScale(float currentRotation, float rotateBy) {
        if (Math.abs((currentRotation + rotateBy) % 360.0f) / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        void var3_3;
        void var2_2;
        void var1_1;
        canvas.save();
        if (degrees != 0.0f) {
            void var4_4;
            var1_1.rotate((float)var4_4, var2_2.x, var2_2.y);
        }
        void v0 = var1_1;
        EditPolygonImageView editPolygonImageView = this;
        float f2 = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
        var1_1.scale(f2, f2, var2_2.x, var2_2.y);
        v0.drawBitmap((Bitmap)var3_3, var2_2.x - (float)(var3_3.getWidth() >> 1), var2_2.y - (float)(var3_3.getHeight() >> 1), this.handlePaint);
        v0.restore();
    }

    private void keepInsideView(PointF point) {
        PointF pointF = point;
        pointF.set(Math.max(0.0f, Math.min(pointF.x, (float)this.getWidth() - this.offsetX * 2.0f)), Math.max(0.0f, Math.min(point.y, (float)this.getHeight() - this.offsetY * 2.0f)));
    }

    private void restoreSelectedEdge() {
        EditPolygonImageView editPolygonImageView = this_;
        editPolygonImageView.selectedEdge.pointA.set(this_.tmpPointA);
        editPolygonImageView.selectedEdge.pointB.set(this_.tmpPointB);
        Object this_ = editPolygonImageView.selectedEdge;
        ((PolygonHelper.Edge)this_).edgeLine.calculateLine(((PolygonHelper.Edge)this_).pointA, ((PolygonHelper.Edge)this_).pointB);
    }

    private void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f4 = f3;
            PointF pointF = this.corners.get(i2);
            f3 = f2 + pointF.x;
            f2 = f4 + pointF.y;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        int n2 = 0;
        while (n2 < 4) {
            PolygonHelper.Edge edge = this.edges.get(n2);
            edge.pointA = this.corners.get(n2);
            int n3 = n2 + 1;
            edge.pointB = this.corners.get(n3 % 4);
            edge.pointFarA = this.corners.get((n2 + 3) % 4);
            this.edges.get(n2).pointFarB = this.corners.get((n2 + 2) % 4);
            n2 = n3;
        }
    }

    private void onImageSizeUpdated() {
        if (this.getDrawable() != null) {
            float f2;
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.offsetX = 0.0f;
            editPolygonImageView.offsetY = 0.0f;
            editPolygonImageView.getImageMatrix().getValues(this.imageMatrix);
            Drawable drawable = editPolygonImageView.getDrawable();
            int n2 = drawable.getIntrinsicHeight();
            float f3 = drawable.getIntrinsicWidth();
            EditPolygonImageView editPolygonImageView2 = this;
            float f4 = f3 * this.getScaleX();
            float f5 = n2;
            float f6 = f5 * this.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f4, f6);
            editPolygonImageView2.scalePortrait = io.scanbot.sdk.b.a.a((View)editPolygonImageView2, 0.0f, rectF) * this.getScaleX();
            editPolygonImageView2.scaleLandscape = io.scanbot.sdk.b.a.a((View)editPolygonImageView2, 90.0f, rectF) * this.getScaleY();
            if (f2 * editPolygonImageView2.scalePortrait < (float)this.getWidth()) {
                this.offsetX = this.getWidth() - (int)(f3 * this.scalePortrait) >> 1;
            }
            if (f5 * this.scalePortrait < (float)this.getHeight()) {
                this.offsetY = this.getHeight() - (int)(f5 * this.scalePortrait) >> 1;
            }
            EditPolygonImageView editPolygonImageView3 = this;
            f4 = this.scalePortrait;
            editPolygonImageView3.polygonHelper.setImageSize((int)(f3 * f4), (int)(f5 * f4));
            editPolygonImageView3.scaleLandscape /= this.scalePortrait;
            editPolygonImageView3.scalePortrait = 1.0f;
            if (editPolygonImageView3.getRotation() / 90.0f % 2.0f == 1.0f) {
                EditPolygonImageView editPolygonImageView4 = this;
                editPolygonImageView4.setScaleX(editPolygonImageView4.scaleLandscape);
                editPolygonImageView4.setScaleY(editPolygonImageView4.scaleLandscape);
            }
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    static /* synthetic */ List access$202(EditPolygonImageView x0, List x1) {
        x0.polygon = x1;
        return x1;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        editPolygonImageView.cornerBitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.cornerDrawable);
        editPolygonImageView.edgeBitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        editPolygonImageView.cornerBitmap.recycle();
        editPolygonImageView.edgeBitmap.recycle();
        editPolygonImageView.editPolygonAnimationEndListener = null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        editPolygonImageView.onImageSizeUpdated();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setPolygon(final List<PointF> polygon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!polygon.isEmpty()) {
                    d d2 = this;
                    EditPolygonImageView.access$202(d2.EditPolygonImageView.this, polygon);
                    if (!d2.EditPolygonImageView.this.corners.isEmpty()) {
                        EditPolygonImageView.this.polygonHelper.getDrawingPolygon(polygon, EditPolygonImageView.this.corners);
                    }
                    EditPolygonImageView.this.invalidate();
                }
            }
        });
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        }
        return this.polygon;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(float rotation) {
        void var1_1;
        if (rotation % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        float f2 = editPolygonImageView.getRotation() - var1_1;
        f2 = editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), f2);
        MagnifierView magnifierView = editPolygonImageView.magnifierView;
        if (magnifierView != null) {
            magnifierView.setImageRotation((float)var1_1);
        }
        EditPolygonImageView editPolygonImageView2 = this;
        this.setScaleX(f2);
        editPolygonImageView2.setScaleY(f2);
        editPolygonImageView2.invalidate();
        super.setRotation((float)var1_1);
    }

    public void setLines(final List<Line2D> horizontalLines, final List<Line2D> verticalLines) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList;
                Object object;
                Object object22;
                ArrayList<Line2D> arrayList2;
                Iterator<Line2D> iterator = arrayList2;
                arrayList2 = new ArrayList<Line2D>(horizontalLines.size());
                for (Object object22 : horizontalLines) {
                    iterator.add(new Line2D(new PointF(object22.getStart().x, object22.getStart().y), new PointF(object22.getEnd().x, object22.getEnd().y)));
                }
                e e2 = this;
                e2.EditPolygonImageView.this.horizontalLines2D.clear();
                e2.EditPolygonImageView.this.horizontalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines((List<Line2D>)((Object)iterator)));
                e2.EditPolygonImageView.this.horizontalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    object = (Line2D)iterator.next();
                    object22 = line;
                    object22();
                    line.calculateLine(object.getStart(), object.getEnd());
                    EditPolygonImageView.this.horizontalLines.add(object22);
                }
                iterator = arrayList;
                arrayList = new ArrayList(verticalLines.size());
                for (Object object22 : verticalLines) {
                    iterator.add(new Line2D(new PointF(object22.getStart().x, object22.getStart().y), new PointF(object22.getEnd().x, object22.getEnd().y)));
                }
                e e3 = this;
                e3.EditPolygonImageView.this.verticalLines2D.clear();
                e3.EditPolygonImageView.this.verticalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines((List<Line2D>)((Object)iterator)));
                e3.EditPolygonImageView.this.verticalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    object = (Line2D)iterator.next();
                    object22 = line;
                    object22();
                    line.calculateLine(object.getStart(), object.getEnd());
                    EditPolygonImageView.this.verticalLines.add(object22);
                }
            }
        });
    }

    public void setEdgeColor(int color) {
        this.paint.setColor(color);
    }

    public void setEdgeColorOnLine(int color) {
        this.paintOnLine.setColor(color);
    }

    public void setEdgeWidth(float width) {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = width;
        editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, 90.0f);
        editPolygonImageView.animate().rotationBy(90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    public void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, -90.0f);
        editPolygonImageView.animate().rotationBy(-90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        EditPolygonImageView editPolygonImageView = this;
        super.dispatchDraw(canvas);
        editPolygonImageView.checkWhetherImageSizeUpdated();
        if (!editPolygonImageView.polygon.isEmpty()) {
            void var1_1;
            var1_1.save();
            var1_1.translate(this.offsetX, this.offsetY);
            for (PolygonHelper.Edge edge : this.edges) {
                PointF pointF = edge.pointA;
                float f2 = pointF.x;
                float f3 = pointF.y;
                PointF pointF2 = edge.pointB;
                float f4 = pointF2.x;
                float f5 = pointF2.y;
                Paint paint = edge.isDetectedLine ? this.paintOnLine : this.paint;
                var1_1.drawLine(f2, f3, f4, f5, paint);
            }
            Object object = this.selectedCorner;
            if (object != null) {
                this.drawHandle((Canvas)var1_1, (PointF)object, this.cornerBitmap, 0.0f);
                var1_1.save();
                var1_1.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    pointF = new PointF(this.selectedCorner.x / ((float)this.getWidth() - this.offsetX * 2.0f), this.selectedCorner.y / ((float)this.getHeight() - this.offsetY * 2.0f));
                    this.magnifierView.drawMagnifier((PointF)object);
                }
                var1_1.restore();
            } else {
                object = this.selectedEdge;
                if (object != null) {
                    this.drawHandle((Canvas)var1_1, ((PolygonHelper.Edge)object).getHandle(), this.edgeBitmap, this.selectedEdge.getAngleInDegrees());
                } else {
                    for (PolygonHelper.Edge edge : this.edges) {
                        this.drawHandle((Canvas)var1_1, edge.getHandle(), this.edgeBitmap, edge.getAngleInDegrees());
                    }
                    object = this.corners.iterator();
                    while (object.hasNext()) {
                        this.drawHandle((Canvas)var1_1, (PointF)object.next(), this.cornerBitmap, 0.0f);
                    }
                }
            }
            var1_1.restore();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent event) {
        Line2D line2D;
        double d2;
        float f2;
        MagnifierView magnifierView;
        block20: {
            switch (event.getAction()) {
                default: {
                    return super.onTouchEvent((MotionEvent)magnifierView);
                }
                case 2: {
                    PointF pointF = this.selectedCorner;
                    if (pointF != null) {
                        EditPolygonImageView editPolygonImageView = this;
                        pointF.set(magnifierView.getX() - this.offsetX, magnifierView.getY() - this.offsetY);
                        editPolygonImageView.keepInsideView(editPolygonImageView.selectedCorner);
                        editPolygonImageView.ensureNoPolygonIntersection();
                        editPolygonImageView.invalidate();
                        return true;
                    }
                    if (this.selectedEdge == null) return true;
                    EditPolygonImageView editPolygonImageView = this;
                    MagnifierView magnifierView2 = magnifierView;
                    float f3 = magnifierView2.getX() - this.selectedEdge.prevX;
                    f2 = magnifierView2.getY() - this.selectedEdge.prevY;
                    editPolygonImageView.finger.offset(f3, f2);
                    editPolygonImageView.tmpPointA.set(this.selectedEdge.pointA);
                    editPolygonImageView.tmpPointB.set(this.selectedEdge.pointB);
                    d2 = Double.MAX_VALUE;
                    line2D = null;
                    if (editPolygonImageView.selectedEdge.isHorizontal()) {
                        break;
                    }
                    for (int i2 = 0; i2 < this.verticalLines.size(); ++i2) {
                        double d3;
                        double d4 = this.verticalLines.get(i2).getDistanceToPoint(this.finger);
                        if (d3 < d2) {
                            line2D = this.verticalLines2D.get(i2);
                        } else {
                            d4 = d2;
                        }
                        d2 = d4;
                    }
                    break block20;
                }
                case 1: 
                case 3: {
                    this.selectedCorner = null;
                    this.selectedEdge = null;
                    magnifierView = this.magnifierView;
                    if (magnifierView != null) {
                        magnifierView.eraseMagnifier();
                    }
                    this.invalidate();
                    return true;
                }
                case 0: {
                    PolygonHelper.Edge edge;
                    PointF pointF;
                    EditPolygonImageView editPolygonImageView = this;
                    int n2 = editPolygonImageView.handleSize >> 1;
                    float f4 = n2;
                    editPolygonImageView.touchRect.set(magnifierView.getX() - this.offsetX - f4, magnifierView.getY() - this.offsetY - f4, magnifierView.getX() - this.offsetX + f4, magnifierView.getY() - this.offsetY + f4);
                    for (PointF pointF2 : editPolygonImageView.corners) {
                        if (!this.touchRect.contains(pointF2.x, pointF2.y)) continue;
                        this.selectedCorner = pointF2;
                        this.invalidate();
                        return true;
                    }
                    Iterator<Object> iterator = this.edges.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        edge = (PolygonHelper.Edge)iterator.next();
                        pointF = edge.getHandle();
                    } while (!this.touchRect.contains(pointF.x, pointF.y));
                    EditPolygonImageView editPolygonImageView2 = this;
                    PolygonHelper.Edge edge2 = this.selectedEdge = edge;
                    edge.prevX = magnifierView.getX();
                    edge2.prevY = magnifierView.getY();
                    edge2.lineA.calculateLine(edge.pointA, edge.pointFarA);
                    edge2.lineB.calculateLine(edge.pointB, edge.pointFarB);
                    editPolygonImageView2.finger.set(pointF);
                    editPolygonImageView2.invalidate();
                    return true;
                }
            }
            for (int i3 = 0; i3 < this.horizontalLines.size(); ++i3) {
                double d5;
                double d6 = this.horizontalLines.get(i3).getDistanceToPoint(this.finger);
                if (d5 < d2) {
                    line2D = this.horizontalLines2D.get(i3);
                } else {
                    d6 = d2;
                }
                d2 = d6;
            }
        }
        if (line2D != null && d2 < (double)this.magneticLineTreshold) {
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.selectedEdge.pointA.set(line2D.getStart());
            editPolygonImageView.selectedEdge.pointB.set(line2D.getEnd());
            editPolygonImageView.selectedEdge.isDetectedLine = true;
        } else {
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.selectedEdge.isDetectedLine = false;
            PointF pointF = editPolygonImageView.selectedEdge.getHandle();
            PointF pointF3 = editPolygonImageView.finger;
            f2 = pointF3.x - pointF.x;
            float f5 = pointF3.y - pointF.y;
            editPolygonImageView.selectedEdge.pointA.offset(f2, f5);
            editPolygonImageView.selectedEdge.pointB.offset(f2, f5);
        }
        EditPolygonImageView editPolygonImageView = this;
        PolygonHelper.Edge edge = editPolygonImageView.selectedEdge;
        edge.edgeLine.calculateLine(edge.pointA, edge.pointB);
        edge = editPolygonImageView.selectedEdge;
        edge = edge.edgeLine.getIntersectionPoint(edge.lineA);
        if (!Float.isNaN(((PointF)edge).x) && !Float.isNaN(((PointF)edge).y)) {
            EditPolygonImageView editPolygonImageView3 = this;
            editPolygonImageView3.selectedEdge.pointA.set((PointF)edge);
            edge = editPolygonImageView3.selectedEdge;
            edge = edge.edgeLine.getIntersectionPoint(edge.lineB);
            if (!Float.isNaN(((PointF)edge).x) && !Float.isNaN(((PointF)edge).y)) {
                EditPolygonImageView editPolygonImageView4 = this;
                editPolygonImageView4.selectedEdge.pointB.set((PointF)edge);
                editPolygonImageView4.keepInsideView(editPolygonImageView4.selectedEdge.pointA);
                editPolygonImageView4.keepInsideView(editPolygonImageView4.selectedEdge.pointB);
                editPolygonImageView4.selectedEdge.prevX = magnifierView.getX();
                editPolygonImageView4.selectedEdge.prevY = magnifierView.getY();
                editPolygonImageView4.invalidate();
                return true;
            }
            this.restoreSelectedEdge();
            return false;
        }
        this.restoreSelectedEdge();
        return false;
    }

    void setMagnifier(MagnifierView magnifier) {
        this.magnifierView = magnifier;
        this.invalidate();
    }

    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }
}

