/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/persistence/PageStorageBase;", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "(Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "pagesDir", "Ljava/io/File;", "getPagesDir", "()Ljava/io/File;", "getDocumentImage", "pageId", "", "getDocumentImagePreview", "getFileName", "imageTypeName", "getFilteredImagePreview", "filterType", "Lio/scanbot/sdk/process/ImageFilterType;", "getOriginalImage", "getOriginalImagePreview", "getPageDir", "getStoredPages", "", "getUnfilteredDocumentImage", "getUnfilteredDocumentImagePreview", "sdk-bundle_release"})
public abstract class PageStorageBase
implements PageStorage {
    private final PageStorageSettings pageStorageSettings;

    private final File getPagesDir() throws IOException {
        return this.getPagesDirectory();
    }

    private final String getFileName(String imageTypeName) {
        String string;
        if (this.pageStorageSettings.getAddImageFileFormatExtension()) {
            string = string + this.pageStorageSettings.getImageFormat().getFormatExtension();
        }
        return string;
    }

    public PageStorageBase(@NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.pageStorageSettings = pageStorageSettings;
    }

    @Override
    @NotNull
    public File getPageDir(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(pagesDir, pageId)");
        return file;
    }

    @Override
    @NotNull
    public File getOriginalImage(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.ORIGINAL_IMAGE.getFileName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026E.fileName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public File getOriginalImagePreview(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.ORIGINAL_IMAGE_PREVIEW.getFileName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026W.fileName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public File getDocumentImage(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.DOCUMENT_IMAGE.getFileName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026E.fileName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public File getDocumentImagePreview(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.DOCUMENT_IMAGE_PREVIEW.getFileName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026W.fileName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public File getFilteredImagePreview(@NotNull String pageId, @NotNull ImageFilterType filterType) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filterType), (String)"filterType");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.FILTERED_PREVIEW.getFileName() + filterType.getFilterName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026filterName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public File getUnfilteredDocumentImage(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.UNFILTERED_DOCUMENT_IMAGE.getFileName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026E.fileName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public File getUnfilteredDocumentImagePreview(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        File file = FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, this.getFileName(PageStorage.ImageType.UNFILTERED_DOCUMENT_IMAGE_PREVIEW.getFileName())});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getFile(\n     \u2026W.fileName)\n            )");
        return file;
    }

    @Override
    @NotNull
    public List<String> getStoredPages() {
        Object[] objectArray = this.getPagesDir().list();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"pagesDir.list()");
        return ArraysKt.asList((Object[])objectArray);
    }
}

