/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import io.scanbot.sap.SapManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        cameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        return contourDetectorFrameHandler;
    }

    public ContourDetectorFrameHandler(Context context) {
        this.contourDetector = new ContourDetector();
        this.sapManager = c.a();
    }

    @Override
    public synchronized boolean handleFrame(byte[] frame, int width, int height, int frameOrientation, Rect finderRect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        DetectionResult detectionResult = this.contourDetector.detect(frame, width, height);
        DetectedFrame detectedFrame = new DetectedFrame(detectionResult, this.contourDetector.getPolygonF(), frameOrientation, width, height, this.contourDetector.getDetectionScore());
        return this.notifyHandlers(detectedFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        if (acceptedAngleScore < 0.0 || acceptedAngleScore > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
        }
        this.contourDetector.setAcceptedAngleScore(acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        if (acceptedSizeScore < 0.0 || acceptedSizeScore > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
        }
        this.contourDetector.setAcceptedSizeScore(acceptedSizeScore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(DetectedFrame detectedFrame) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(detectedFrame);
            }
        }
        return bl;
    }

    public static class DetectedFrame {
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;

        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = 0.0;
        }

        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = detectionScore;
        }
    }

    public static interface ResultHandler {
        public boolean handleResult(DetectedFrame var1);
    }
}

