/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera.sensor;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import net.doo.snap.camera.sensor.SignificantMoveListener;

public class SignificantMoveCatcher
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor accelerometer;
    private float[] gravity;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private SignificantMoveListener moveListener = null;

    public SignificantMoveCatcher(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        this.acceleration = 0.0f;
        this.currentAcceleration = 9.80665f;
        this.lastAcceleration = 9.80665f;
    }

    private void registerSensorListener() {
        if (this.accelerometer != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.accelerometer, 2);
        }
    }

    private void unregisterSensorListener() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public void registerSignificantMoveListener(SignificantMoveListener listener) {
        if (listener != null && this.moveListener != listener) {
            this.moveListener = listener;
            this.registerSensorListener();
        }
    }

    public void unregisterSignificantMoveListener(SignificantMoveListener listener) {
        this.moveListener = null;
        this.unregisterSensorListener();
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            this.gravity = (float[])event.values.clone();
            float f2 = this.gravity[0];
            float f3 = this.gravity[1];
            float f4 = this.gravity[2];
            this.lastAcceleration = this.currentAcceleration;
            this.currentAcceleration = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
            float f5 = this.currentAcceleration - this.lastAcceleration;
            this.acceleration = this.acceleration * 0.9f + f5;
            if (this.moveListener != null && this.acceleration > this.moveListener.getSignificantMoveThreshold()) {
                this.moveListener.onSignificantMove();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

