/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.dcscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class DCScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private DCScanner dcScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static DCScannerFrameHandler attach(ScanbotCameraView cameraView, DCScanner dcScanner) {
        DCScannerFrameHandler dCScannerFrameHandler = new DCScannerFrameHandler(cameraView.getContext(), dcScanner);
        cameraView.getPreviewBuffer().addFrameHandler(dCScannerFrameHandler);
        return dCScannerFrameHandler;
    }

    public DCScannerFrameHandler(Context context, DCScanner dcScanner) {
        this.dcScanner = dcScanner;
        this.sapManager = c.a();
    }

    @Override
    public synchronized boolean handleFrame(byte[] frame, int width, int height, int frameOrientation, Rect finderRect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        DisabilityCertificateRecognizerResultInfo disabilityCertificateRecognizerResultInfo = this.dcScanner.recognizeDC(frame, width, height, frameOrientation);
        return this.notifyHandlers(disabilityCertificateRecognizerResultInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(DisabilityCertificateRecognizerResultInfo recognitionResult) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(recognitionResult);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(DisabilityCertificateRecognizerResultInfo var1);
    }
}

