/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence.cleanup;

import android.util.Pair;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.g;
import net.doo.snap.process.util.DocumentDraft;

public class Cleaner {
    private final UnreferencedSourcesProvider a;
    private final PageStoreStrategy b;
    private final DocumentStoreStrategy c;
    private final g d;

    @Inject
    public Cleaner(UnreferencedSourcesProvider unreferencedSourcesProvider, PageStoreStrategy pageStoreStrategy, DocumentStoreStrategy documentStoreStrategy, g processingInfoProvider) {
        this.a = unreferencedSourcesProvider;
        this.b = pageStoreStrategy;
        this.c = documentStoreStrategy;
        this.d = processingInfoProvider;
    }

    public void cleanUp() {
        for (Pair<String, String> object : this.a.getUnreferencedDocuments()) {
            this.c.eraseDocument((String)object.first, (String)object.second);
        }
        for (String string2 : this.a.getUnreferencedSDKPages()) {
            this.b.erasePage(string2);
        }
        for (DocumentDraft documentDraft : this.d.b()) {
            this.cleanUpPagesData(documentDraft.getPages());
        }
    }

    public void cleanUpPagesData(Page[] pages) {
        for (Page page : pages) {
            this.b.eraseTempPageData(page.getId());
        }
    }

    public void cleanUpDocumentData(Document document) {
        this.c.eraseDocument(document.getId(), document.getName());
    }

    public void cleanUpDocumentThumbnail(Document document) {
        this.c.eraseDocumentThumbnail(document.getId());
    }
}

