/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

public class YUVUtil {
    public static byte[] rotateYUV21Image(int cameraRotation, byte[] data, int imageWidth, int imageHeight) {
        switch (cameraRotation) {
            case 0: {
                return data;
            }
            case 90: {
                return YUVUtil.rotateCW(data, imageWidth, imageHeight);
            }
            case 180: {
                return YUVUtil.rotate180(data, imageWidth, imageHeight);
            }
            case 270: {
                return YUVUtil.rotateCCW(data, imageWidth, imageHeight);
            }
        }
        return data;
    }

    private static byte[] rotateCW(byte[] data, int imageWidth, int imageHeight) {
        byte[] byArray = new byte[imageWidth * imageHeight];
        int n2 = 0;
        for (int i2 = 0; i2 < imageWidth; ++i2) {
            for (int i3 = imageHeight - 1; i3 >= 0; --i3) {
                byArray[n2] = data[i3 * imageWidth + i2];
                ++n2;
            }
        }
        return byArray;
    }

    private static byte[] rotate180(byte[] data, int imageWidth, int imageHeight) {
        int n2 = imageWidth * imageHeight;
        byte[] byArray = new byte[n2];
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[n3] = data[i2];
            --n3;
        }
        return byArray;
    }

    private static byte[] rotateCCW(byte[] data, int imageWidth, int imageHeight) {
        int n2 = imageWidth * imageHeight;
        byte[] byArray = new byte[n2];
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < imageWidth; ++i2) {
            for (int i3 = imageHeight - 1; i3 >= 0; --i3) {
                byArray[n3] = data[i3 * imageWidth + i2];
                --n3;
            }
        }
        return byArray;
    }
}

