/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.b;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.OptimizationType;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.TextRecognition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016J\u001e\u0010\u001e\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "textRecognition", "Lnet/doo/snap/process/TextRecognition;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Lnet/doo/snap/process/TextRecognition;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "convertFilterToOptimizationType", "Lnet/doo/snap/entity/OptimizationType;", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "getInstalledLanguages", "", "Lnet/doo/snap/entity/Language;", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lnet/doo/snap/entity/Document;", "recognizeTextFromPages", "Lnet/doo/snap/process/OcrResult;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUri", "imageFileUris", "Landroid/net/Uri;", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUri", "scanbot-sdk_release"})
public final class a
implements OpticalCharacterRecognizer {
    private final TextRecognition a;
    private final PageFactory b;
    private final BlobManager c;
    private final PageFileStorage d;

    @Override
    @NotNull
    public OcrResult recognizeTextFromUri(@NotNull List<? extends Uri> imageFileUris) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Iterable iterable = imageFileUris;
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            Uri uri = (Uri)t2;
            collection = collection2;
            net.doo.snap.entity.Page page = this.b.buildPage(UriKt.toFile((Uri)uri));
            collection.add(page);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withoutPDF((List<net.doo.snap.entity.Page>)collection).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026  }\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Iterable iterable = pages;
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            net.doo.snap.entity.Page page;
            Page page2 = (Page)t2;
            collection = collection2;
            net.doo.snap.entity.Page page3 = page = this.b.buildPage(page2.getPageId(), new File(this.d.getImageURI(page2.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page3, (String)"oldPage");
            page3.setOptimizationType(this.a(page2.getFilter()));
            net.doo.snap.entity.Page page4 = page;
            collection.add(page4);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withoutPDF((List<net.doo.snap.entity.Page>)collection).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026  }\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUri(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageSize), (String)"pageSize");
        Iterable iterable = imageFileUris;
        Document document = this.a();
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            net.doo.snap.entity.Page page;
            Uri uri = (Uri)t2;
            collection = collection2;
            net.doo.snap.entity.Page page2 = page = this.b.buildPage(UriKt.toFile((Uri)uri));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setPageSize(pageSize);
            net.doo.snap.entity.Page page3 = page;
            collection.add(page3);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withPDF(document, (List<net.doo.snap.entity.Page>)collection).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026  }\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageSize), (String)"pageSize");
        Iterable iterable = pages;
        Document document = this.a();
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            net.doo.snap.entity.Page page;
            Page page2 = (Page)t2;
            collection = collection2;
            net.doo.snap.entity.Page page3 = page = this.b.buildPage(page2.getPageId(), new File(this.d.getImageURI(page2.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page3, (String)"oldPage");
            page3.setOptimizationType(this.a(page2.getFilter()));
            page.setPolygon(page2.getPolygon());
            page.setPageSize(pageSize);
            net.doo.snap.entity.Page page4 = page;
            collection.add(page4);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withPDF(document, (List<net.doo.snap.entity.Page>)collection).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026  }\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        File file = this.c.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        Set<Language> set = this.c.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }

    private final OptimizationType a(ImageFilterType imageFilterType) {
        OptimizationType optimizationType;
        switch (io.scanbot.sdk.ocr.b.a[imageFilterType.ordinal()]) {
            case 1: {
                optimizationType = OptimizationType.NONE;
                break;
            }
            case 2: {
                optimizationType = OptimizationType.COLOR_ENHANCED;
                break;
            }
            case 3: {
                optimizationType = OptimizationType.GRAYSCALE;
                break;
            }
            case 4: {
                optimizationType = OptimizationType.BINARIZED;
                break;
            }
            case 5: {
                optimizationType = OptimizationType.COLOR_DOCUMENT;
                break;
            }
            case 6: {
                optimizationType = OptimizationType.PURE_BINARIZED;
                break;
            }
            case 7: {
                optimizationType = OptimizationType.BACKGROUND_CLEAN;
                break;
            }
            case 8: {
                optimizationType = OptimizationType.BLACK_AND_WHITE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return optimizationType;
    }

    private final Document a() {
        Document document;
        Document document2 = document = new Document();
        document2.setId(UUID.randomUUID().toString());
        document2.setName(document2.getId() + ".pdf");
        document2.setOcrStatus(OcrStatus.PENDING);
        return document;
    }

    @Inject
    public a(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.a = textRecognition;
        this.b = pageFactory;
        this.c = blobManager;
        this.d = pageFileStorage;
    }
}

