/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class BlobManager {
    private final BlobStoreStrategy blobStoreStrategy;
    private final AssetManager assetManager;
    private final BlobFactory blobFactory;
    private final Logger logger = LoggerProvider.getLogger();

    @Inject
    public BlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.assetManager = assetManager;
        this.blobFactory = blobFactory;
    }

    public boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) {
        for (Blob blob : blobs) {
            if (this.isBlobAvailable(blob)) continue;
            return false;
        }
        return true;
    }

    public boolean isBlobAvailable(@NotNull Blob blob) {
        File file = new File(blob.getLocalPath());
        return file.exists();
    }

    @NotNull
    public Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        EnumSet<Language> enumSet = EnumSet.noneOf(Language.class);
        File file = this.blobStoreStrategy.getOCRDataDirectory();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return enumSet;
        }
        for (File file2 : fileArray) {
            String string2;
            String string3;
            Language language;
            if (file2.isDirectory() || (language = Language.languageByIso(string3 = FilenameUtils.removeExtension((String)(string2 = file2.getName())))) == null || !this.allBlobsAvailable(this.blobFactory.ocrLanguageBlobs())) continue;
            enumSet.add(language);
        }
        return enumSet;
    }

    @NotNull
    public File getOCRBlobsDirectory() throws IOException {
        File file = this.blobStoreStrategy.getOCRDataDirectory();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't get OCR blobs directory");
        }
        return file;
    }

    @NotNull
    public File getBanksDataFile() throws IOException {
        File file = this.blobStoreStrategy.getBanksDataFile();
        if (!file.exists()) {
            throw new IOException("Can't get banks data file");
        }
        return file;
    }

    @NotNull
    public File getMRZTraineddataFile() throws IOException {
        File file = this.blobStoreStrategy.getMRZTraindataFile();
        if (!file.exists()) {
            throw new IOException("Can't get MRZ traineddata file");
        }
        return file;
    }

    @NotNull
    public File getMRZCascadeFile() throws IOException {
        File file = this.blobStoreStrategy.getMRZCascadeFile();
        if (!file.exists()) {
            throw new IOException("Can't get MRZ cascade file");
        }
        return file;
    }

    @NotNull
    public File getRoutingNumberCascadeFile() throws IOException {
        File file = this.blobStoreStrategy.getRoutingNumberCascadeFile();
        if (!file.exists()) {
            throw new IOException("Can't get RoutingNumberCascade file");
        }
        return file;
    }

    @NotNull
    public File getAccountNumberCascadeFile() throws IOException {
        File file = this.blobStoreStrategy.getAccountNumberCascadeFile();
        if (!file.exists()) {
            throw new IOException("Can't get AccountNumberCascade file");
        }
        return file;
    }

    public long fetch(@NotNull Blob blob) throws IOException {
        if (this.isBlobAvailable(blob)) {
            return -1L;
        }
        this.ensureDirectoryCreated(blob);
        Uri uri = Uri.parse((String)blob.getRemotePath());
        return this.copyFromAssets(blob, uri);
    }

    private long copyFromAssets(Blob blob, Uri blobUri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.assetManager.open(blobUri.getPath()), (File)new File(blob.getLocalPath()));
        return -1L;
    }

    private void ensureDirectoryCreated(Blob blob) throws IOException {
        File file = new File(blob.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create destination directory");
        }
    }
}

