/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.util.SparseArray;

public enum OptimizationType {
    NONE(0, "none"),
    COLOR_ENHANCED(1, "color_enhanced"),
    GRAYSCALE(2, "grayscale"),
    BINARIZED(3, "binarized"),
    COLOR_DOCUMENT(4, "color_document"),
    PURE_BINARIZED(11, "pure_binarized"),
    BACKGROUND_CLEAN(13, "background_clean"),
    BLACK_AND_WHITE(14, "black_and_white"),
    OTSU_BINARIZATION(15, "otsu_binarization"),
    DEEP_BINARIZATION(16, "deep_binarization"),
    EDGE_HIGHLIGHT(17, "edge_highlight");

    private static final SparseArray<OptimizationType> code2Type;
    private final int code;
    private final String name;

    private OptimizationType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static OptimizationType getByCode(int code) {
        OptimizationType optimizationType = (OptimizationType)((Object)code2Type.get(code));
        if (optimizationType == null) {
            throw new IllegalStateException("No Optimization type for code: " + code);
        }
        return optimizationType;
    }

    static {
        code2Type = new SparseArray();
        for (OptimizationType optimizationType : OptimizationType.values()) {
            code2Type.put(optimizationType.getCode(), (Object)optimizationType);
        }
    }
}

