/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Looper;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.entity.OptimizationType;
import net.doo.snap.entity.Page;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class PageStoreStrategy {
    public static final String a = "filtered";
    public static final String b = "sdk_snapping_pages";
    private final Application c;
    private final SharedPreferences d;
    private final Logger e = LoggerProvider.getLogger();

    @Inject
    public PageStoreStrategy(Application context, SharedPreferences preferences) {
        this.c = context;
        this.d = preferences;
    }

    @NotNull
    public File getPagesDir() throws IOException {
        String string2 = this.d.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!string2.isEmpty()) {
            return net.doo.snap.util.FileUtils.getFilesDirOrShowError(string2, b);
        }
        return net.doo.snap.util.FileUtils.getFilesDirOrShowError(net.doo.snap.util.FileUtils.getAppFilesDirOrShowError((Context)this.c, "scanbot-sdk").getPath(), b);
    }

    @NotNull
    public File getPageDir(String pageId) throws IOException {
        return FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId});
    }

    @NotNull
    public File getImageFile(@NotNull String pageId, @NotNull Page.ImageType imageType) throws IOException {
        return FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, imageType.getFileName()});
    }

    public File getFilteredPreviewFile(@NotNull String pageId, @NotNull OptimizationType optimizationType) throws IOException {
        return FileUtils.getFile((File)this.getPageDir(pageId), (String[])new String[]{a, optimizationType.getName()});
    }

    public void erasePage(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                protected Void a(String ... stringArray) {
                    String string2 = stringArray[0];
                    PageStoreStrategy.this.b(string2);
                    return null;
                }

                protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                    return this.a((String[])objectArray);
                }
            }.execute((Object[])new String[]{pageId});
        } else {
            this.b(pageId);
        }
    }

    public void eraseTempPageData(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                protected Void a(String ... stringArray) {
                    String string2 = stringArray[0];
                    PageStoreStrategy.this.a(string2);
                    return null;
                }

                protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                    return this.a((String[])objectArray);
                }
            }.execute((Object[])new String[]{pageId});
        } else {
            this.a(pageId);
        }
    }

    private void a(String string2) {
        try {
            File file = this.getImageFile(string2, Page.ImageType.ORIGINAL);
            if (file.exists()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (IOException iOException) {
            this.e.logException(iOException);
        }
    }

    private void b(String string2) {
        try {
            File file = this.getPageDir(string2);
            if (file.exists() && file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (IOException iOException) {
            this.e.logException(iOException);
        }
    }
}

