/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEReader;
import com.google.zxing.oned.rss.RSS14Reader;
import com.google.zxing.oned.rss.expanded.RSSExpandedReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ZXingBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.c.c;
import net.doo.snap.util.YUVUtil;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J2\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J%\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0 H\u0002\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0*H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/barcode/ZXingBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "reader", "Lcom/google/zxing/Reader;", "sapManager", "Lio/scanbot/sap/SapManager;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "zxingBarcodeFormat", "Lcom/google/zxing/BarcodeFormat;", "getCornerPoints", "", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "cornerPoints", "Lcom/google/zxing/ResultPoint;", "([Lcom/google/zxing/ResultPoint;)[Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getFormat", "barcodeFormat", "reinitReader", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class ZXingBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger;
    private Reader reader;
    private final SapManager sapManager;
    private final AtomicBoolean barcodeScanEnabled;

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Intrinsics.checkParameterIsNotNull(barcodeFormats, (String)"barcodeFormats");
        if (barcodeFormats.isEmpty()) {
            this.reader = (Reader)new MultiFormatReader();
        } else if (barcodeFormats.size() == 1) {
            this.reinitReader(barcodeFormats.get(0));
        } else {
            com.google.zxing.BarcodeFormat barcodeFormat;
            HashMap hashMap = new HashMap();
            com.google.zxing.BarcodeFormat barcodeFormat2 = new ArrayList();
            for (BarcodeFormat object2 : barcodeFormats) {
                barcodeFormat = this.getFormat(object2);
                if (barcodeFormat == null) continue;
                barcodeFormat2.add(barcodeFormat);
            }
            Map map = hashMap;
            DecodeHintType decodeHintType = DecodeHintType.POSSIBLE_FORMATS;
            barcodeFormat = barcodeFormat2;
            map.put(decodeHintType, barcodeFormat);
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            multiFormatReader.setHints((Map)hashMap);
            this.reader = (Reader)multiFormatReader;
        }
    }

    private final com.google.zxing.BarcodeFormat getFormat(BarcodeFormat barcodeFormat) {
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barcodeFormat.ordinal()]) {
            case 1: {
                return com.google.zxing.BarcodeFormat.AZTEC;
            }
            case 2: {
                return com.google.zxing.BarcodeFormat.CODABAR;
            }
            case 3: {
                return com.google.zxing.BarcodeFormat.CODE_39;
            }
            case 4: {
                return com.google.zxing.BarcodeFormat.CODE_93;
            }
            case 5: {
                return com.google.zxing.BarcodeFormat.CODE_128;
            }
            case 6: {
                return com.google.zxing.BarcodeFormat.DATA_MATRIX;
            }
            case 7: {
                return com.google.zxing.BarcodeFormat.EAN_8;
            }
            case 8: {
                return com.google.zxing.BarcodeFormat.EAN_13;
            }
            case 9: {
                return com.google.zxing.BarcodeFormat.ITF;
            }
            case 10: {
                return com.google.zxing.BarcodeFormat.MAXICODE;
            }
            case 11: {
                return com.google.zxing.BarcodeFormat.PDF_417;
            }
            case 12: {
                return com.google.zxing.BarcodeFormat.QR_CODE;
            }
            case 13: {
                return com.google.zxing.BarcodeFormat.RSS_14;
            }
            case 14: {
                return com.google.zxing.BarcodeFormat.RSS_EXPANDED;
            }
            case 15: {
                return com.google.zxing.BarcodeFormat.UPC_A;
            }
            case 16: {
                return com.google.zxing.BarcodeFormat.UPC_E;
            }
            case 17: {
                return com.google.zxing.BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            Result result;
            byte[] byArray = YUVUtil.rotateYUV21Image(frameOrientation, data, width, height);
            PlanarYUVLuminanceSource planarYUVLuminanceSource = frameOrientation % 180 == 0 ? new PlanarYUVLuminanceSource(byArray, width, height, 0, 0, width, height, false) : new PlanarYUVLuminanceSource(byArray, height, width, 0, 0, height, width, false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            if (this.reader instanceof MultiFormatReader) {
                Reader reader = this.reader;
                if (reader == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.zxing.MultiFormatReader");
                }
                Result result2 = ((MultiFormatReader)reader).decodeWithState(binaryBitmap);
                Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"(reader as MultiFormatRe\u2026).decodeWithState(bitmap)");
                result = result2;
            } else {
                Result result3 = this.reader.decode(binaryBitmap);
                Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"reader.decode(bitmap)");
                result = result3;
            }
            String string2 = result.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.text");
            byte[] byArray2 = result.getRawBytes();
            com.google.zxing.ResultPoint[] resultPointArray = result.getResultPoints();
            Intrinsics.checkExpressionValueIsNotNull((Object)resultPointArray, (String)"result.resultPoints");
            BarcodeScanningResult barcodeScanningResult = new BarcodeScanningResult(string2, byArray2, this.getCornerPoints(resultPointArray), this.getAppFormat(result.getBarcodeFormat()), 0L, 16, null);
            return barcodeScanningResult;
        }
        catch (NotFoundException notFoundException) {
        }
        catch (FormatException formatException) {
        }
        catch (ChecksumException checksumException) {
            this.logger.d("ZXingBarcodeDetector", checksumException.getMessage());
        }
        finally {
            this.reader.reset();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation, @NotNull Rect finderRect) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            Result result;
            byte[] byArray = YUVUtil.rotateYUV21Image(frameOrientation, data, width, height);
            PlanarYUVLuminanceSource planarYUVLuminanceSource = frameOrientation % 180 == 0 ? new PlanarYUVLuminanceSource(byArray, width, height, finderRect.left, finderRect.top, finderRect.width(), finderRect.height(), false) : new PlanarYUVLuminanceSource(byArray, height, width, finderRect.left, finderRect.top, finderRect.width(), finderRect.height(), false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            if (this.reader instanceof MultiFormatReader) {
                Reader reader = this.reader;
                if (reader == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.zxing.MultiFormatReader");
                }
                Result result2 = ((MultiFormatReader)reader).decodeWithState(binaryBitmap);
                Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"(reader as MultiFormatRe\u2026r).decodeWithState(image)");
                result = result2;
            } else {
                Result result3 = this.reader.decode(binaryBitmap);
                Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"reader.decode(image)");
                result = result3;
            }
            String string2 = result.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.text");
            byte[] byArray2 = result.getRawBytes();
            com.google.zxing.ResultPoint[] resultPointArray = result.getResultPoints();
            Intrinsics.checkExpressionValueIsNotNull((Object)resultPointArray, (String)"result.resultPoints");
            BarcodeScanningResult barcodeScanningResult = new BarcodeScanningResult(string2, byArray2, this.getCornerPoints(resultPointArray), this.getAppFormat(result.getBarcodeFormat()), 0L, 16, null);
            return barcodeScanningResult;
        }
        catch (NotFoundException notFoundException) {
        }
        catch (FormatException formatException) {
        }
        catch (ChecksumException checksumException) {
            this.logger.d("ZXingBarcodeDetector", checksumException.getMessage());
        }
        finally {
            this.reader.reset();
        }
        return null;
    }

    private final ResultPoint[] getCornerPoints(com.google.zxing.ResultPoint[] cornerPoints) {
        Collection collection;
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        for (com.google.zxing.ResultPoint collection2 : cornerPoints) {
            if (collection2 != null) {
                arrayList.add(new ResultPoint(collection2.getX(), collection2.getY()));
                continue;
            }
            arrayList.add(null);
        }
        Collection collection3 = collection = (Collection)arrayList;
        ResultPoint[] resultPointArray = collection3.toArray(new ResultPoint[0]);
        if (resultPointArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return resultPointArray;
    }

    private final BarcodeFormat getAppFormat(com.google.zxing.BarcodeFormat zxingBarcodeFormat) {
        if (zxingBarcodeFormat == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$1[zxingBarcodeFormat.ordinal()]) {
            case 1: {
                return BarcodeFormat.AZTEC;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 10: {
                return BarcodeFormat.MAXICODE;
            }
            case 11: {
                return BarcodeFormat.PDF_417;
            }
            case 12: {
                return BarcodeFormat.QR_CODE;
            }
            case 13: {
                return BarcodeFormat.RSS_14;
            }
            case 14: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 15: {
                return BarcodeFormat.UPC_A;
            }
            case 16: {
                return BarcodeFormat.UPC_E;
            }
            case 17: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private final void reinitReader(BarcodeFormat barcodeFormat) {
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$2[barcodeFormat.ordinal()]) {
            case 1: {
                this.reader = (Reader)new MultiFormatReader();
                break;
            }
            case 2: {
                this.reader = (Reader)new AztecReader();
                break;
            }
            case 3: {
                this.reader = (Reader)new CodaBarReader();
                break;
            }
            case 4: {
                this.reader = (Reader)new Code39Reader();
                break;
            }
            case 5: {
                this.reader = (Reader)new Code93Reader();
                break;
            }
            case 6: {
                this.reader = (Reader)new Code128Reader();
                break;
            }
            case 7: {
                this.reader = (Reader)new DataMatrixReader();
                break;
            }
            case 8: {
                this.reader = (Reader)new EAN8Reader();
                break;
            }
            case 9: {
                this.reader = (Reader)new EAN13Reader();
                break;
            }
            case 10: {
                this.reader = (Reader)new ITFReader();
                break;
            }
            case 11: {
                this.reader = (Reader)new MaxiCodeReader();
                break;
            }
            case 12: {
                this.reader = (Reader)new PDF417Reader();
                break;
            }
            case 13: {
                this.reader = (Reader)new QRCodeReader();
                break;
            }
            case 14: {
                this.reader = (Reader)new RSS14Reader();
                break;
            }
            case 15: {
                this.reader = (Reader)new RSSExpandedReader();
                break;
            }
            case 16: {
                this.reader = (Reader)new UPCAReader();
                break;
            }
            case 17: {
                this.reader = (Reader)new UPCEReader();
                break;
            }
            case 18: {
                this.reader = (Reader)new MultiFormatUPCEANReader(null);
                break;
            }
            case 19: {
                this.reader = (Reader)new MultiFormatReader();
            }
        }
    }

    @Inject
    public ZXingBarcodeDetector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = LoggerProvider.getLogger();
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.reader = (Reader)new MultiFormatReader();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }
}

