/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.GoogleVisionBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.doo.snap.c.c;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J%\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/barcode/GoogleVisionBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "detector", "Lcom/google/android/gms/vision/barcode/BarcodeDetector;", "sapManager", "Lio/scanbot/sap/SapManager;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "googleVisionFormat", "getCornerPoints", "", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "cornerPoints", "Landroid/graphics/Point;", "([Landroid/graphics/Point;)[Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getGVFormat", "barcodeFormat", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class GoogleVisionBarcodeDetector
implements ScanbotBarcodeDetector {
    private final SapManager sapManager;
    private BarcodeDetector detector;
    private final AtomicBoolean barcodeScanEnabled;
    private final Context context;

    private final ResultPoint[] getCornerPoints(Point[] pointArray) {
        ArrayList arrayList;
        ResultPoint[] resultPointArray = arrayList;
        arrayList = new ArrayList();
        for (Point point : pointArray) {
            resultPointArray.add(new ResultPoint(point.x, point.y));
        }
        if ((resultPointArray = resultPointArray.toArray(new ResultPoint[0])) != null) {
            return resultPointArray;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    private final BarcodeFormat getAppFormat(int n2) {
        switch (n2) {
            default: {
                return BarcodeFormat.UNKNOWN;
            }
            case 4096: {
                return BarcodeFormat.AZTEC;
            }
            case 2048: {
                return BarcodeFormat.PDF_417;
            }
            case 1024: {
                return BarcodeFormat.UPC_E;
            }
            case 512: {
                return BarcodeFormat.UPC_A;
            }
            case 256: {
                return BarcodeFormat.QR_CODE;
            }
            case 128: {
                return BarcodeFormat.ITF;
            }
            case 64: {
                return BarcodeFormat.EAN_8;
            }
            case 32: {
                return BarcodeFormat.EAN_13;
            }
            case 16: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 8: {
                return BarcodeFormat.CODABAR;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 1: 
        }
        return BarcodeFormat.CODE_128;
    }

    private final int getGVFormat(BarcodeFormat barcodeFormat) {
        switch (GoogleVisionBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barcodeFormat.ordinal()]) {
            default: {
                return 0;
            }
            case 19: {
                return 1024;
            }
            case 18: {
                return 512;
            }
            case 17: {
                return 256;
            }
            case 16: {
                return 2048;
            }
            case 15: {
                return 128;
            }
            case 14: {
                return 32;
            }
            case 13: {
                return 64;
            }
            case 12: {
                return 16;
            }
            case 11: {
                return 1;
            }
            case 10: {
                return 4;
            }
            case 9: {
                return 2;
            }
            case 8: {
                return 8;
            }
            case 7: {
                return 4096;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return 0;
    }

    @Inject
    public GoogleVisionBarcodeDetector(@NotNull Context context) {
        GoogleVisionBarcodeDetector googleVisionBarcodeDetector = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        googleVisionBarcodeDetector.context = context;
        googleVisionBarcodeDetector.barcodeScanEnabled = new AtomicBoolean(true);
        googleVisionBarcodeDetector.detector = new BarcodeDetector.Builder(this.context).build();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        googleVisionBarcodeDetector.sapManager = sapManager;
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeDetector) {
        BarcodeDetector barcodeDetector2 = barcodeDetector;
        Intrinsics.checkParameterIsNotNull(barcodeDetector2, (String)"barcodeFormats");
        if (barcodeDetector2.isEmpty()) {
            barcodeDetector = this.detector;
            if (barcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            barcodeDetector.release();
            this.detector = new BarcodeDetector.Builder(this.context).build();
        } else {
            Object object = this.detector;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            object.release();
            int n2 = 0;
            object = barcodeDetector.iterator();
            while (object.hasNext()) {
                n2 |= this.getGVFormat((BarcodeFormat)((Object)object.next()));
            }
            this.detector = new BarcodeDetector.Builder(this.context).setBarcodeFormats(n2).build();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] object, int n2, int n3, int n4) {
        BarcodeScanningResult barcodeScanningResult;
        SparseArray sparseArray;
        void var3_12;
        void var2_9;
        Frame.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
        BarcodeScanningResult barcodeScanningResult2 = null;
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        BarcodeDetector barcodeDetector = this.detector;
        if (barcodeDetector == null) return null;
        if (barcodeDetector == null) {
            Intrinsics.throwNpe();
        }
        if (!barcodeDetector.isOperational()) {
            return null;
        }
        ByteBuffer byteBuffer = MappedByteBuffer.wrap(object);
        barcodeDetector = builder;
        barcodeDetector();
        Frame frame = builder.setImageData(byteBuffer, (int)var2_9, (int)var3_12, 17).build();
        BarcodeDetector barcodeDetector2 = this.detector;
        if (barcodeDetector2 == null) {
            Intrinsics.throwNpe();
        }
        if ((sparseArray = barcodeDetector2.detect(frame)).size() <= 0) return barcodeScanningResult2;
        Barcode barcode = (Barcode)sparseArray.valueAt(0);
        String string = barcode.rawValue;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"barcode.rawValue");
        ResultPoint[] resultPointArray = barcode.rawValue;
        Intrinsics.checkExpressionValueIsNotNull((Object)resultPointArray, (String)"barcode.rawValue");
        Charset charset = Charsets.UTF_8;
        if (barcode.rawValue == null) throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        byte[] byArray = resultPointArray.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Intrinsics.checkExpressionValueIsNotNull((Object)barcode.cornerPoints, (String)"barcode.cornerPoints");
        resultPointArray = this.getCornerPoints(barcode.cornerPoints);
        BarcodeFormat barcodeFormat = this.getAppFormat(barcode.format);
        long l2 = 0L;
        int n5 = 16;
        DefaultConstructorMarker defaultConstructorMarker = null;
        BarcodeScanningResult barcodeScanningResult3 = barcodeScanningResult;
        barcodeScanningResult = new BarcodeScanningResult(string, byArray, resultPointArray, barcodeFormat, l2, n5, defaultConstructorMarker);
        return barcodeScanningResult3;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] var1_1, int var2_3, int var3_5, int var4_9, @NotNull Rect var5_13) {
        block28: {
            block29: {
                block27: {
                    block26: {
                        block32: {
                            block31: {
                                block30: {
                                    Intrinsics.checkParameterIsNotNull((Object)var1_1 /* !! */ , (String)"data");
                                    Intrinsics.checkParameterIsNotNull((Object)var5_13, (String)"finderRect");
                                    var6_15 = null;
                                    if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                                        return null;
                                    }
                                    if (!this.sapManager.isLicenseActive()) break block28;
                                    var7_17 = this.detector;
                                    if (var7_17 == null) break block29;
                                    if (var7_17 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    if (!var7_17.isOperational()) break block29;
                                    var7_18 = var4_9 != 0 && var4_9 != 180 ? var3_5 : var2_3;
                                    if (var4_9 == 0 || var4_9 == 180) ** GOTO lbl17
                                    var8_19 = var5_13.height();
                                    break block30;
lbl17:
                                    // 1 sources

                                    var8_19 = var5_13.width();
                                }
                                if (var4_9 == 0 || var4_9 == 180) ** GOTO lbl23
                                var9_21 = var5_13.width();
                                break block31;
lbl23:
                                // 1 sources

                                var9_21 = var5_13.height();
                            }
                            if (var4_9 == 0 || var4_9 == 180) ** GOTO lbl29
                            var10_23 = var5_13.top;
                            break block32;
lbl29:
                            // 1 sources

                            var10_23 = var5_13.left;
                        }
                        if (var4_9 == 0 || var4_9 == 180) break block26;
                        var4_9 = var7_18 - var5_13.right;
                        ** GOTO lbl38
                    }
                    var4_9 = var5_13.top;
lbl38:
                    // 2 sources

                    v0 = this;
                    v1 = var1_1 /* !! */ ;
                    v2 = v3;
                    var1_1 /* !! */  = (byte[])v3;
                    v2(var10_23, var4_9, var10_23 + var8_19, var4_9 + var9_21);
                    var4_10 = MappedByteBuffer.wrap(v1);
                    var5_13 = v4;
                    v5 = var5_13;
                    v6 = var4_10;
                    v7 = var2_3;
                    v8 = var3_5;
                    var5_13();
                    var2_4 /* !! */  = v5.setImageData(v6, v7, v8, 17).build();
                    var3_6 = v0.detector;
                    if (var3_6 != null) ** GOTO lbl57
                    Intrinsics.throwNpe();
lbl57:
                    // 2 sources

                    var2_4 /* !! */  = var3_6.detect(var2_4 /* !! */ );
                    v9 = var2_4 /* !! */ ;
                    try {
                        var4_11 = v9.size();
                    }
                    catch (Throwable var1_2) {
                        throw var1_2;
                    }
                    finally {
                        this = this.detector;
                        if (this == null) {
                            Intrinsics.throwNpe();
                        }
                        this.release();
                    }
                    for (var3_7 = 0; var3_7 < var4_11; ++var3_7) {
                        v10 /* !! */  = var1_1 /* !! */ ;
                        v11 = (Barcode)var2_4 /* !! */ .valueAt(var3_7);
                        v12 = var5_13;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"barcode");
                        if (!v10 /* !! */ .contains(v11.getBoundingBox())) continue;
                        v13 = var5_13;
                        v14 = v13;
                        v15 = v13.rawValue;
                        v16 = v15;
                        var1_1 /* !! */  = (byte[])v15;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"barcode.rawValue");
                        v17 = v14.rawValue;
                        var2_4 /* !! */  = var2_4 /* !! */ ;
                        v18 = var2_4 /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"barcode.rawValue");
                        var3_8 = Charsets.UTF_8;
                        if (v17 != null) {
                            v19 = this;
                            v20 = var5_13;
                            v21 = this;
                            v22 = var5_13;
                            v23 = var2_4 /* !! */ .getBytes((Charset)var3_8);
                            v24 = v23;
                            var2_4 /* !! */  = (Frame)v23;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"(this as java.lang.String).getBytes(charset)");
                            v25 = v22.cornerPoints;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"barcode.cornerPoints");
                            var3_8 = v21.getCornerPoints(v22.cornerPoints);
                            var4_12 = v19.getAppFormat(v20.format);
                            var6_16 = 0L;
                            var5_14 = 16;
                            var8_20 = null;
                            var9_22 = v26;
                            v26 = new BarcodeScanningResult((String)var1_1 /* !! */ , (byte[])var2_4 /* !! */ , var3_8, var4_12, var6_16, var5_14, var8_20);
                            break block27;
                        }
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    var9_22 = var6_15;
                }
                return var9_22;
            }
            return null;
        }
        throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
    }
}

