/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor$WhenMappings;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.PolygonHelper;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "(Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "createPage", "Lio/scanbot/sdk/persistence/Page;", "srcImage", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "createPage$scanbot_sdk_release", "", "createPreviewTo", "previewFile", "Ljava/io/File;", "bitmap", "image", "erasePageData", "", "page", "saveBitmapTo", "file", "Configuration", "scanbot-sdk_release"})
public final class PageStorageProcessor {
    private final Logger logger;
    private final PageStorage pageStorage;
    private final PageStorageSettings pageStorageSettings;

    @Inject
    public PageStorageProcessor(@NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings) {
        PageStorageProcessor pageStorageProcessor = this;
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.pageStorage = pageStorage;
        pageStorageProcessor.pageStorageSettings = pageStorageSettings;
        pageStorageProcessor.logger = LoggerProvider.getLogger();
    }

    @NotNull
    public final Page createPage$scanbot_sdk_release(@NotNull byte[] byArray, @NotNull Configuration configuration) {
        BitmapFactory.Options options;
        PageStorageProcessor pageStorageProcessor = pageStorageProcessor2;
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        PageStorageProcessor pageStorageProcessor2 = options;
        options = new BitmapFactory.Options();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)pageStorageProcessor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"originalBitmap");
        return pageStorageProcessor.createPage$scanbot_sdk_release(bitmap, configuration);
    }

    @NotNull
    public final Page createPage$scanbot_sdk_release(@NotNull Bitmap bitmap, @NotNull Configuration configuration) {
        Page.Size size;
        Object object;
        DetectionResult detectionResult;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        FileUtils.forceMkdir((File)((PageStorageProcessor)object).pageStorage.getPageDir(string));
        if (configuration.getImageOrientation() > 0 || configuration.getImageScale() != 1.0f) {
            Matrix matrix;
            object2 = matrix;
            matrix = new Matrix();
            if (configuration.getImageOrientation() > 0) {
                object2.setRotate((float)configuration.getImageOrientation(), (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            }
            if (configuration.getImageScale() != 1.0f) {
                object2.postScale(configuration.getImageScale(), configuration.getImageScale());
            }
            Bitmap bitmap2 = bitmap;
            int n2 = bitmap2.getWidth();
            int n3 = bitmap2.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n2, (int)n3, (Matrix)object2, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
        }
        PageStorageProcessor pageStorageProcessor = object;
        pageStorageProcessor.saveBitmapTo(pageStorageProcessor.pageStorage.getOriginalImage(string), bitmap);
        if (configuration.getCreatePreview()) {
            PageStorageProcessor pageStorageProcessor2 = object;
            Bitmap bitmap3 = bitmap;
            double d2 = (double)((PageStorageProcessor)object).pageStorageSettings.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
            object2 = Bitmap.createScaledBitmap((Bitmap)bitmap3, (int)((int)((double)bitmap3.getWidth() * d2)), (int)((int)((double)bitmap.getHeight() * d2)), (boolean)false);
            File file = pageStorageProcessor2.pageStorage.getOriginalImagePreview(string);
            Object object3 = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"preview");
            pageStorageProcessor2.saveBitmapTo(file, (Bitmap)object3);
        }
        object2 = PolygonHelper.Companion.getFulPolygon();
        DetectionResult detectionResult2 = DetectionResult.ERROR_NOTHING_DETECTED;
        if (configuration.getCreateDocument()) {
            ContourDetector contourDetector;
            detectionResult2 = contourDetector;
            detectionResult2();
            detectionResult2.setRequiredAspectRatios(configuration.getRequiredAspectRatios());
            detectionResult2.setRectOfInterest(configuration.getRectOfInterest());
            detectionResult = contourDetector.detect(bitmap);
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult, (String)"detector.detect(originalBitmap)");
            if (detectionResult != DetectionResult.ERROR_NOTHING_DETECTED && detectionResult != DetectionResult.ERROR_TOO_DARK && detectionResult != DetectionResult.ERROR_TOO_NOISY) {
                object2 = detectionResult2.getPolygonF();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"detector.polygonF");
            }
            bitmap = detectionResult2.processImageF(bitmap, (List)object2, ImageFilterType.NONE.getCode());
            if (configuration.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && configuration.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
                bitmap = BitmapUtils.scaleIfNeeded(bitmap, configuration.getDocumentImageSizeLimit().getWidth(), configuration.getDocumentImageSizeLimit().getHeight());
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapUtils.scaleIfNeede\u2026entImageSizeLimit.height)");
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"documentBitmapBeforeScaling");
            }
            Object object4 = object;
            ((PageStorageProcessor)object4).saveBitmapTo(((PageStorageProcessor)object4).pageStorage.getDocumentImage(string), bitmap);
            ((PageStorageProcessor)object4).saveBitmapTo(((PageStorageProcessor)object4).pageStorage.getUnfilteredDocumentImage(string), bitmap);
            if (configuration.getCreatePreview()) {
                Object object5 = object;
                Bitmap bitmap4 = bitmap;
                double d3 = (double)((PageStorageProcessor)object).pageStorageSettings.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
                object = Bitmap.createScaledBitmap((Bitmap)bitmap4, (int)((int)((double)bitmap4.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
                File file = ((PageStorageProcessor)object5).pageStorage.getDocumentImagePreview(string);
                Object object6 = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"preview");
                ((PageStorageProcessor)object5).saveBitmapTo(file, (Bitmap)object6);
                ((PageStorageProcessor)object5).saveBitmapTo(((PageStorageProcessor)object5).pageStorage.getUnfilteredDocumentImagePreview(string), (Bitmap)object);
            }
        } else {
            detectionResult = detectionResult2;
        }
        object = size;
        size = new Page.Size(configuration.getDocumentImageSizeLimit().getWidth(), configuration.getDocumentImageSizeLimit().getHeight());
        return new Page(string, (List)object2, detectionResult, null, (Page.Size)object, 8, null);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] byArray) {
        BitmapFactory.Options options;
        PageStorageProcessor pageStorageProcessor = pageStorageProcessor2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"bitmap");
        PageStorageProcessor pageStorageProcessor2 = options;
        options = new BitmapFactory.Options();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)pageStorageProcessor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"originalBitmap");
        pageStorageProcessor.saveBitmapTo(file, bitmap);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block12: {
            FileOutputStream fileOutputStream2;
            block10: {
                FileOutputStream fileOutputStream3;
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
                Object var3_8 = null;
                fileOutputStream = fileOutputStream3;
                fileOutputStream3 = new FileOutputStream(file);
                try {
                    void var1_6;
                    block11: {
                        try {
                            Bitmap.CompressFormat compressFormat;
                            int n2 = PageStorageProcessor$WhenMappings.$EnumSwitchMapping$0[this.pageStorageSettings.getImageFormat().ordinal()];
                            if (n2 != 1) {
                                if (n2 != 2) {
                                    throw new NoWhenBranchMatchedException();
                                }
                                compressFormat = Bitmap.CompressFormat.PNG;
                            } else {
                                compressFormat = Bitmap.CompressFormat.JPEG;
                            }
                            fileOutputStream2 = fileOutputStream;
                            bitmap.compress(compressFormat, this.pageStorageSettings.getImageQuality(), (OutputStream)fileOutputStream);
                            break block10;
                        }
                        catch (IOException iOException) {
                            break block11;
                        }
                        catch (Throwable throwable2) {
                            fileOutputStream = var3_8;
                            break block12;
                        }
                        catch (IOException iOException) {
                            fileOutputStream = var3_8;
                        }
                    }
                    fileOutputStream2 = fileOutputStream;
                    this.logger.logException((Throwable)var1_6);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream2);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File file, @NotNull byte[] object) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"image");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length);
        object = bitmap;
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bitmap");
        double d3 = d2 / (double)Math.max(object.getHeight(), object.getWidth());
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)object.getHeight() * d3)), (boolean)false);
        object = bitmap2;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"preview");
        this.saveBitmapTo(file, (Bitmap)object);
        return bitmap2;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        double d2 = (double)this.pageStorageSettings.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
        Bitmap bitmap3 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d2)), (int)((int)((double)bitmap.getHeight() * d2)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(file, bitmap3);
        return bitmap;
    }

    public final void erasePageData(@NotNull Page serializable) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)serializable, (String)"page");
            serializable = this.pageStorage.getPageDir(((Page)serializable).getPageId());
            if (!((File)serializable).exists()) break block4;
            if (!((File)serializable).isDirectory()) break block4;
            try {
                FileUtils.deleteDirectory((File)serializable);
            }
            catch (IOException iOException) {
                this.logger.logException(iOException);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0002+,BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003JU\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "createPreview", "", "createDocument", "documentImageSizeLimit", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "imageScale", "", "imageOrientation", "", "requiredAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "rectOfInterest", "Landroid/graphics/RectF;", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;)V", "getCreateDocument", "()Z", "getCreatePreview", "getDocumentImageSizeLimit", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getImageOrientation", "()I", "getImageScale", "()F", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "Size", "scanbot-sdk_release"})
    public static final class Configuration {
        public static final Companion Companion = new Companion(null);
        private final boolean createPreview;
        private final boolean createDocument;
        @NotNull
        private final Size documentImageSizeLimit;
        private final float imageScale;
        private final int imageOrientation;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @NotNull
        private final RectF rectOfInterest;

        public Configuration(boolean bl, boolean bl2, @NotNull Size size, float f2, int n2, @NotNull List<? extends PageAspectRatio> list, @NotNull RectF rectF) {
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(list, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectOfInterest");
            this.createPreview = bl;
            this.createDocument = bl2;
            this.documentImageSizeLimit = size;
            this.imageScale = f2;
            this.imageOrientation = n2;
            this.requiredAspectRatios = list;
            this.rectOfInterest = rectF;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f2, int n2, List list, RectF rectF, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                bl = true;
            }
            if ((n3 & 2) != 0) {
                bl2 = false;
            }
            if ((n3 & 4) != 0) {
                Size size2;
                size = size2;
                size2 = new Size(0, 0, 3, null);
            }
            if ((n3 & 8) != 0) {
                f2 = 1.0f;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x20) != 0) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
            }
            if ((n3 & 0x40) != 0) {
                RectF rectF2;
                rectF = rectF2;
                rectF2 = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            this(bl, bl2, size, f2, n2, list, rectF);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, 127, null);
        }

        @NotNull
        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f2, int n2, List list, RectF rectF, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = configuration.createPreview;
            }
            if ((n3 & 2) != 0) {
                bl2 = configuration.createDocument;
            }
            if ((n3 & 4) != 0) {
                size = configuration.documentImageSizeLimit;
            }
            if ((n3 & 8) != 0) {
                f2 = configuration.imageScale;
            }
            if ((n3 & 0x10) != 0) {
                n2 = configuration.imageOrientation;
            }
            if ((n3 & 0x20) != 0) {
                list = configuration.requiredAspectRatios;
            }
            if ((n3 & 0x40) != 0) {
                rectF = configuration.rectOfInterest;
            }
            return configuration.copy(bl, bl2, size, f2, n2, list, rectF);
        }

        public final boolean getCreatePreview() {
            return this.createPreview;
        }

        public final boolean getCreateDocument() {
            return this.createDocument;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.documentImageSizeLimit;
        }

        public final float getImageScale() {
            return this.imageScale;
        }

        public final int getImageOrientation() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public final boolean component1() {
            return this.createPreview;
        }

        public final boolean component2() {
            return this.createDocument;
        }

        @NotNull
        public final Size component3() {
            return this.documentImageSizeLimit;
        }

        public final float component4() {
            return this.imageScale;
        }

        public final int component5() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> component6() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF component7() {
            return this.rectOfInterest;
        }

        @NotNull
        public final Configuration copy(boolean bl, boolean bl2, @NotNull Size size, float f2, int n2, @NotNull List<? extends PageAspectRatio> list, @NotNull RectF rectF) {
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(list, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectOfInterest");
            return new Configuration(bl, bl2, size, f2, n2, list, rectF);
        }

        @NotNull
        public String toString() {
            return "Configuration(createPreview=" + this.createPreview + ", createDocument=" + this.createDocument + ", documentImageSizeLimit=" + this.documentImageSizeLimit + ", imageScale=" + this.imageScale + ", imageOrientation=" + this.imageOrientation + ", requiredAspectRatios=" + this.requiredAspectRatios + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            int n2 = this.createPreview ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            n2 *= 31;
            int n3 = this.createDocument ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            n2 = (n2 + n3) * 31;
            Size size = this.documentImageSizeLimit;
            int n4 = size != null ? size.hashCode() : 0;
            n2 = (((n2 + n4) * 31 + Float.floatToIntBits(this.imageScale)) * 31 + this.imageOrientation) * 31;
            List<PageAspectRatio> list = this.requiredAspectRatios;
            int n5 = list != null ? ((Object)list).hashCode() : 0;
            int n6 = (n2 + n5) * 31;
            RectF rectF = this.rectOfInterest;
            int n7 = rectF != null ? rectF.hashCode() : 0;
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block2: {
                block3: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    object = (Configuration)object;
                    if (this.createPreview == ((Configuration)object).createPreview && this.createDocument == ((Configuration)object).createDocument && Intrinsics.areEqual((Object)this.documentImageSizeLimit, (Object)((Configuration)object).documentImageSizeLimit) && Float.compare(this.imageScale, ((Configuration)object).imageScale) == 0 && this.imageOrientation == ((Configuration)object).imageOrientation && Intrinsics.areEqual(this.requiredAspectRatios, ((Configuration)object).requiredAspectRatios) && Intrinsics.areEqual((Object)this.rectOfInterest, (Object)((Configuration)object).rectOfInterest)) break block2;
                }
                return false;
            }
            return true;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "scanbot-sdk_release"})
        public static final class Size
        implements Serializable {
            private final int width;
            private final int height;

            public Size(int n2, int n3) {
                this.width = n2;
                this.height = n3;
            }

            public /* synthetic */ Size(int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n4 & 1) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                if ((n4 & 2) != 0) {
                    n3 = Integer.MAX_VALUE;
                }
                this(n2, n3);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            @NotNull
            public static /* synthetic */ Size copy$default(Size size, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n2 = size.width;
                }
                if ((n4 & 2) != 0) {
                    n3 = size.height;
                }
                return size.copy(n2, n3);
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            @NotNull
            public final Size copy(int n2, int n3) {
                return new Size(n2, n3);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                return this.width * 31 + this.height;
            }

            public boolean equals(@Nullable Object object) {
                block2: {
                    block3: {
                        if (this == object) break block2;
                        if (!(object instanceof Size)) break block3;
                        object = (Size)object;
                        if (this.width == ((Size)object).width && this.height == ((Size)object).height) break block2;
                    }
                    return false;
                }
                return true;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "()V", "DEFAULT", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "scanbot-sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, 127, null);
            }
        }
    }
}

