/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.doo.snap.entity.OptimizationType;
import net.doo.snap.entity.RotationType;
import net.doo.snap.entity.b;
import net.doo.snap.entity.c;

public class Page
implements Parcelable {
    public static final String FILTERED_FOLDER = "filtered";
    public static Parcelable.Creator<Page> CREATOR = new c();
    private final String id;
    private final Bundle parameters;
    private OptimizationType optimizationType;
    private RotationType rotationType;
    private List<PointF> polygon;
    private SparseArray<Point> imageSizes;
    private boolean processed;
    private PDFPageSize pageSize;

    public Page() {
        this.optimizationType = OptimizationType.NONE;
        this.rotationType = RotationType.ROTATION_0;
        this.polygon = new b(this);
        this.imageSizes = new SparseArray();
        this.processed = false;
        this.pageSize = PDFPageSize.FROM_IMAGE;
        this.id = UUID.randomUUID().toString();
        this.parameters = new Bundle();
    }

    public Page(String string) {
        Page page = this;
        this.optimizationType = OptimizationType.NONE;
        this.rotationType = RotationType.ROTATION_0;
        this.polygon = new b(this);
        this.imageSizes = new SparseArray();
        this.processed = false;
        this.pageSize = PDFPageSize.FROM_IMAGE;
        page.id = string;
        page.parameters = new Bundle();
    }

    private Page(Parcel parcel) {
        this.optimizationType = OptimizationType.NONE;
        this.rotationType = RotationType.ROTATION_0;
        this.polygon = new b(this);
        this.imageSizes = new SparseArray();
        this.processed = false;
        this.pageSize = PDFPageSize.FROM_IMAGE;
        this.id = parcel.readString();
        this.parameters = parcel.readBundle();
        int n2 = parcel.readInt();
        OptimizationType optimizationType = n2 == -1 ? null : OptimizationType.values()[n2];
        this.optimizationType = optimizationType;
        int n3 = parcel.readInt();
        RotationType rotationType = n3 == -1 ? null : RotationType.values()[n3];
        Parcel parcel2 = parcel;
        this.rotationType = rotationType;
        parcel2.readTypedList(this.polygon, PointF.CREATOR);
        this.imageSizes = parcel2.readSparseArray(SparseArray.class.getClassLoader());
    }

    /* synthetic */ Page(Parcel parcel, b b2) {
        this(parcel);
    }

    public String getId() {
        return this.id;
    }

    public OptimizationType getOptimizationType() {
        return this.optimizationType;
    }

    public void setOptimizationType(OptimizationType optimizationType) {
        this.optimizationType = optimizationType;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public List<PointF> getPolygon() {
        List<PointF> list = ((Page)((Object)list)).polygon;
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void setPolygon(List<PointF> list) {
        if (list != null && list.size() == 4) {
            this.polygon = list;
            return;
        }
    }

    public void setImageSize(ImageType imageType, int n2, int n3) {
        this.imageSizes.put(imageType.ordinal(), (Object)new Point(n2, n3));
    }

    public Point getImageSize(ImageType imageType) {
        return (Point)this.imageSizes.get(imageType.ordinal());
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public Bundle getParameters() {
        return this.parameters;
    }

    public void setPageSize(PDFPageSize pDFPageSize) {
        this.pageSize = pDFPageSize;
    }

    public PDFPageSize getPageSize() {
        return this.pageSize;
    }

    public boolean equals(Object object) {
        if (page2 == object) {
            return true;
        }
        if (!(object instanceof Page)) {
            return false;
        }
        Page page = page2;
        Page page2 = (Page)object;
        return page.id.equals(page2.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.id);
        parcel.writeBundle(this.parameters);
        OptimizationType optimizationType = this.optimizationType;
        int n3 = optimizationType == null ? -1 : optimizationType.ordinal();
        parcel.writeInt(n3);
        RotationType rotationType = this.rotationType;
        int n4 = rotationType == null ? -1 : rotationType.ordinal();
        parcel.writeInt(n4);
        parcel.writeTypedList(this.polygon);
        parcel.writeSparseArray(this.imageSizes);
    }

    public static enum ImageType {
        ORIGINAL("original"),
        PREVIEW("preview"),
        OPTIMIZED_PREVIEW("optimized_preview"),
        OPTIMIZED("optimized"),
        OVERLAY("overlay"),
        OVERLAY_TMP("overlay_tmp");

        private String fileName;

        private ImageType(String string2) {
            this.fileName = string2;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

