/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import net.doo.snap.util.CursorUtil;

public class FileChooserUtils {
    private static final String CONTENT_SCHEME = "content";
    private static final String FILE_SCHEME = "file";
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context stringArray, Uri stringArray2) {
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)stringArray, (Uri)stringArray2)) {
            if (FileChooserUtils.isExternalStorageDocument((Uri)stringArray2)) {
                stringArray = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                if ("primary".equalsIgnoreCase(stringArray[0])) {
                    return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                }
            } else {
                if (FileChooserUtils.isDownloadsDocument((Uri)stringArray2)) {
                    return FileChooserUtils.getDataColumn((Context)stringArray, ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray2))), null, null);
                }
                if (FileChooserUtils.isMediaDocument((Uri)stringArray2)) {
                    stringArray2 = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                    Uri uri = null;
                    if ("image".equals(stringArray2[0])) {
                        uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    }
                    String[] stringArray3 = stringArray;
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = stringArray2[1];
                    return FileChooserUtils.getDataColumn((Context)stringArray3, uri, "_id=?", stringArray);
                }
            }
        } else {
            if (CONTENT_SCHEME.equalsIgnoreCase(stringArray2.getScheme())) {
                return FileChooserUtils.getDataColumn((Context)stringArray, (Uri)stringArray2, null, null);
            }
            if (FILE_SCHEME.equalsIgnoreCase(stringArray2.getScheme())) {
                return stringArray2.getPath();
            }
        }
        return null;
    }

    public static String getDataColumn(Context context, Uri uri, String string2, String[] stringArray) {
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = "_data";
        if (context == null) {
            return uri.getPath();
        }
        if ((context = context.getContentResolver()) == null) {
            return uri.getPath();
        }
        if ((context = context.query(uri, stringArray3, string2, stringArray, null)) != null) {
            Context context2 = context;
            int n2 = context2.getColumnIndexOrThrow("_data");
            context.moveToFirst();
            String string3 = context2.getString(n2);
            CursorUtil.closeQuietly((Cursor)context);
            return string3;
        }
        return uri.getPath();
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return EXTERNALSTORAGE_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return DOWNLOADS_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return MEDIA_AUTHORITY.equals(uri.getAuthority());
    }
}

